/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.rules.api.ScopeEnum;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;

public enum ChecksTableColumns {
    ID("ID", 40),
    CHECKNAME("Check Name", 30),
    SHORTNAME("Short Name", 64),
    SCOPE("Scope", Arrays.stream(ScopeEnum.values()).map(se -> se.toString().length()).max(Integer::compareTo).orElse(4) + 1),
    CHANGESET_TYPE("Type", 6),
    STATUS("Status", 8),
    PRIORITY("Priority", 12),
    SEVERITY("Severity", 9),
    CUSTOMIZATION("Customization", 30),
    DESCRIPTION("Description", 30),
    FILE("File", 30);

    public static final String DEFAULT_COLUMNS_ARG;
    public static final String DEFAULT_COLUMNS_ARG_WITH_FILE;
    public static final String EVERY_COLUMN_ARG;
    private final String name;
    private final int width;

    public String getNameArgumentCase() {
        return ChecksTableColumns.toArgumentCase(this.name);
    }

    public String toString() {
        return this.getNameArgumentCase();
    }

    public static List<String> getColumnNamesList(Collection<ChecksTableColumns> columns) {
        return columns.stream().map(ChecksTableColumns::getName).collect(Collectors.toList());
    }

    public static List<Integer> getColumnWidthsList(Collection<ChecksTableColumns> columns) {
        return columns.stream().map(ChecksTableColumns::getWidth).collect(Collectors.toList());
    }

    private static String toArgumentCase(String value) {
        return StringUtil.toLowerWithoutWhitespaces((String)value);
    }

    private ChecksTableColumns(String name, int width) {
        this.name = name;
        this.width = width;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    static {
        DEFAULT_COLUMNS_ARG = ChecksTableColumns.toArgumentCase(String.format("%s,%s,%s,%s,%s,%s", new Object[]{SHORTNAME, SCOPE, STATUS, SEVERITY, CUSTOMIZATION, DESCRIPTION}));
        DEFAULT_COLUMNS_ARG_WITH_FILE = ChecksTableColumns.toArgumentCase(String.format("%s,%s", new Object[]{DEFAULT_COLUMNS_ARG, FILE}));
        EVERY_COLUMN_ARG = ChecksTableColumns.toArgumentCase(String.format("%s,%s,%s,%s,%s", new Object[]{ID, CHECKNAME, CHANGESET_TYPE, PRIORITY, DEFAULT_COLUMNS_ARG_WITH_FILE}));
    }
}

