/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.flow.condition.Condition;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.LiquibaseQualityCheckResult;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import liquibase.changelog.ChangeSet;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public abstract class AbstractChainedChecksRule
extends AbstractLiquibaseDynamicForecastRule {
    private final ParserContext parserContext = new ParserContext();
    private final Map<String, String> expandedLogicConditionals = new HashMap<String, String>();
    private final Set<String> disabledChecksCache = new HashSet<String>();
    private final Map<String, Set<String>> nonApplicableChecksCache = new LinkedHashMap<String, Set<String>>();

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule rule) {
        return false;
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        return false;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, Map<ChangeSet, LiquibaseQualityCheckResult> changeSetResults, DynamicRule dynamicRule, CheckSettingsConfig config) {
        return this.evaluateChain(changeSet, changeSetResults, dynamicRule, config, false);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, Map<ChangeSet, LiquibaseQualityCheckResult> changeSetResults, DynamicRule dynamicRule, CheckSettingsConfig config) {
        return this.evaluateChain(changeSet, changeSetResults, dynamicRule, config, true);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, Map<DatabaseObject, LiquibaseQualityCheckResult> databaseResults, DynamicRule dynamicRule, CheckSettingsConfig config) {
        return this.evaluateChain(databaseObject, databaseResults, dynamicRule, config);
    }

    public void resetCheckCaches() {
        this.disabledChecksCache.clear();
        this.nonApplicableChecksCache.clear();
    }

    private boolean evaluateChain(ChangeSet changeSet, Map<ChangeSet, LiquibaseQualityCheckResult> changeSetResults, DynamicRule dynamicRule, CheckSettingsConfig config, boolean isRollback) {
        ArrayList<String> checks = new ArrayList<String>();
        AbstractChainedChecksRule.listAllChecksInChain(dynamicRule, config, checks);
        List<String> disabledCheckNames = new ResultsChecker<ChangeSet>().determineDisabledChecks(changeSet, changeSetResults, checks);
        if (!disabledCheckNames.isEmpty()) {
            this.addDisabledChecksFailure(changeSet, dynamicRule, disabledCheckNames);
            return this.returnAtEndOfRule(changeSet, dynamicRule, false);
        }
        ResultsChecker resultsChecker = new ResultsChecker();
        boolean checksMatch = checks.stream().allMatch(c -> resultsChecker.resultsExist(c, changeSet, changeSetResults, isRollback));
        if (!checksMatch) {
            this.addNonApplicableChecksFailure(changeSet, dynamicRule, new ResultsChecker<ChangeSet>().determineNonApplicableChecks(changeSet, changeSetResults, checks));
            return this.returnAtEndOfRule(changeSet, (AbstractConfigurableRule)dynamicRule);
        }
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        AbstractChainedChecksRule.setupVariables(dynamicRule, changeSetResults.get(changeSet).getRuleResults(), variables, config, isRollback);
        try {
            String logicalCondition = (String)dynamicRule.getParameter(DynamicRuleParameterEnum.LOGIC_CONDITIONAL).getValue();
            logicalCondition = this.expandChainedChecksCache(logicalCondition, dynamicRule, config);
            boolean returnValue = this.execute(logicalCondition, variables);
            if (returnValue) {
                DynamicRuleParameter messageParam = dynamicRule.getParameter(DynamicRuleParameterEnum.MESSAGE);
                String messageTemplate = (String)messageParam.getValue();
                Map<String, String> checkRuleResults = AbstractChainedChecksRule.createCheckRuleResultsMap(checks, variables);
                this.addFailureRuleIteration(changeSet, checkRuleResults, this.getFailureMessage(messageTemplate, dynamicRule.getShortName(), logicalCondition, checkRuleResults), dynamicRule, true, false);
            }
        }
        catch (CompileException e) {
            String message = Condition.handleCompileException(e);
            this.addFailureRuleIteration(changeSet, message, dynamicRule, false);
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.addFailureRuleIteration(changeSet, message, dynamicRule, false);
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, false);
    }

    private static Map<String, String> createCheckRuleResultsMap(List<String> checks, Map<String, Boolean> variables) {
        LinkedHashMap<String, String> checkRuleResults = new LinkedHashMap<String, String>();
        checks.forEach(c -> {
            boolean value = (Boolean)variables.get(c);
            String displayValue = value ? "triggered" : "false";
            checkRuleResults.put((String)c, displayValue);
        });
        return checkRuleResults;
    }

    private boolean evaluateChain(DatabaseObject databaseObject, Map<DatabaseObject, LiquibaseQualityCheckResult> databaseResults, DynamicRule dynamicRule, CheckSettingsConfig config) {
        ArrayList<String> checks = new ArrayList<String>();
        AbstractChainedChecksRule.listAllChecksInChain(dynamicRule, config, checks);
        List<String> disabledCheckNames = new ResultsChecker<DatabaseObject>().determineDisabledChecks(databaseObject, databaseResults, checks);
        if (!disabledCheckNames.isEmpty()) {
            this.addDisabledChecksFailure(databaseObject, dynamicRule, disabledCheckNames);
            return this.returnAtEndOfRule(databaseObject, (AbstractConfigurableRule)dynamicRule);
        }
        boolean checksMatch = checks.stream().allMatch(c -> new ResultsChecker().resultsExist(c, databaseObject, databaseResults, false));
        if (!checksMatch) {
            this.addNonApplicableChecksFailure(databaseObject, dynamicRule, new ResultsChecker<DatabaseObject>().determineNonApplicableChecks(databaseObject, databaseResults, checks));
            return this.returnAtEndOfRule(databaseObject, (AbstractConfigurableRule)dynamicRule);
        }
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        AbstractChainedChecksRule.setupVariables(dynamicRule, databaseResults.get(databaseObject).getRuleResults(), variables, config, false);
        try {
            String logicalCondition = (String)dynamicRule.getParameter(DynamicRuleParameterEnum.LOGIC_CONDITIONAL).getValue();
            logicalCondition = this.expandChainedChecksCache(logicalCondition, dynamicRule, config);
            boolean returnValue = this.execute(logicalCondition, variables);
            if (returnValue) {
                DynamicRuleParameter messageParam = dynamicRule.getParameter(DynamicRuleParameterEnum.MESSAGE);
                String messageTemplate = (String)messageParam.getValue();
                Map<String, String> checkRuleResultsMap = AbstractChainedChecksRule.createCheckRuleResultsMap(checks, variables);
                this.addFailureRuleIteration(databaseObject, checkRuleResultsMap, this.getFailureMessage(messageTemplate, dynamicRule.getShortName(), logicalCondition, checkRuleResultsMap), (AbstractConfigurableRule)dynamicRule, true);
            }
        }
        catch (CompileException e) {
            String message = Condition.handleCompileException(e);
            this.addFailureRuleIteration(databaseObject, message, (AbstractConfigurableRule)dynamicRule);
        }
        catch (Exception e) {
            String message = e.getMessage();
            this.addFailureRuleIteration(databaseObject, message, (AbstractConfigurableRule)dynamicRule);
        }
        return this.returnAtEndOfRule(databaseObject, (AbstractConfigurableRule)dynamicRule);
    }

    public static String expandChainedChecks(String logicConditional, DynamicRule dynamicRule, CheckSettingsConfig config) {
        AtomicReference<String> refLogicConditional = new AtomicReference<String>(logicConditional);
        List<String> checks = dynamicRule.listChecksInChain();
        checks.forEach(c -> {
            String edited = (String)refLogicConditional.get();
            DynamicRule dr = config.getDynamicRuleByShortName((String)c);
            if (dr != null && dr.isChained()) {
                String chainedCheckLogical = (String)dr.getParameter(DynamicRuleParameterEnum.LOGIC_CONDITIONAL).getValue();
                edited = edited.replaceAll("([(|& ]*?)(?i)" + c + "([)|& ]*?)", "$1 (" + chainedCheckLogical + "$2)");
                AbstractChainedChecksRule.expandChainedChecks(edited, dr, config);
            }
            refLogicConditional.set(edited);
        });
        return refLogicConditional.get();
    }

    private String expandChainedChecksCache(String logicConditional, DynamicRule dynamicRule, CheckSettingsConfig config) {
        if (this.expandedLogicConditionals.containsKey(logicConditional)) {
            return this.expandedLogicConditionals.get(logicConditional);
        }
        String expanded = AbstractChainedChecksRule.expandChainedChecks(logicConditional, dynamicRule, config);
        this.expandedLogicConditionals.put(logicConditional, expanded);
        return expanded;
    }

    private void addDisabledChecksFailure(Object object, DynamicRule dynamicRule, List<String> disabledCheckNames) {
        String first = "Check";
        String second = "is";
        if (disabledCheckNames.size() > 1) {
            first = "Checks";
            second = "are";
        }
        disabledCheckNames.removeAll(this.disabledChecksCache);
        if (disabledCheckNames.isEmpty()) {
            return;
        }
        String message = String.format("This chain is broken! %s '%s' %s disabled or deleted.  Enable check(s) and try again with 'liquibase checks run --checkname='%s'", first, StringUtil.join(disabledCheckNames, (String)","), second, dynamicRule.getShortName());
        String resultsMessageTemplate = "Warning: Broken Check.\nCheck '%s' inaccessible.";
        HashMap<String, String> disabledCheckReasons = new HashMap<String, String>();
        disabledCheckNames.forEach(checkName -> disabledCheckReasons.put((String)checkName, String.format(resultsMessageTemplate, checkName)));
        if (object instanceof ChangeSet) {
            this.addFailureRuleIteration((ChangeSet)object, disabledCheckReasons, message, dynamicRule, false, false);
        } else {
            this.addFailureRuleIteration((DatabaseObject)object, disabledCheckReasons, message, (AbstractConfigurableRule)dynamicRule, false);
        }
        this.disabledChecksCache.addAll(disabledCheckNames);
    }

    private void addNonApplicableChecksFailure(Object object, DynamicRule dynamicRule, List<String> nonApplicable) {
        if (nonApplicable.isEmpty()) {
            return;
        }
        if (object instanceof ChangeSet) {
            ChangeSet changeSet = (ChangeSet)object;
            String key = AbstractChainedChecksRule.createChangeSetKey(changeSet);
            String plurality = "are";
            if (nonApplicable.size() == 1) {
                plurality = "is";
            }
            String message = String.format("The chain '%s' will not be evaluated because it contains non-applicable check(s): '%s' %s not applicable to change types '%s'.  To list every non-applicable instance set --verbose=true.", dynamicRule.getShortName(), StringUtil.join(nonApplicable, (String)","), plurality, key.replace("::", ","));
            DynamicRule modifiedDynamicRule = DynamicRule.fromDynamicRule(dynamicRule);
            modifiedDynamicRule.setSeverity(SeverityEnum.INFO);
            this.addNonApplicableRuleIteration(changeSet, message, RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE, (AbstractConfigurableRule)modifiedDynamicRule);
            this.addToCache(nonApplicable, key);
        } else {
            DatabaseObject databaseObject = (DatabaseObject)object;
            String plurality = "are";
            if (nonApplicable.size() == 1) {
                plurality = "is";
            }
            String message = String.format("The chain '%s' will not be evaluated because it contains non-applicable check(s): '%s' %s not applicable to database object type '%s'. To list every non-applicable instance set --verbose=true.", dynamicRule.getShortName(), StringUtil.join(nonApplicable, (String)","), plurality, databaseObject.getObjectTypeName());
            DynamicRule modifiedDynamicRule = DynamicRule.fromDynamicRule(dynamicRule);
            modifiedDynamicRule.setSeverity(SeverityEnum.INFO);
            this.addNonApplicableRuleIteration(databaseObject, message, RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE, (AbstractConfigurableRule)modifiedDynamicRule);
            this.addToCache(nonApplicable, databaseObject.getObjectTypeName());
        }
    }

    private void addToCache(List<String> nonApplicable, String key) {
        if (this.nonApplicableChecksCache.containsKey(key)) {
            this.nonApplicableChecksCache.get(key).addAll(nonApplicable);
        } else {
            this.nonApplicableChecksCache.put(key, new HashSet<String>(nonApplicable));
        }
    }

    private static String createChangeSetKey(ChangeSet changeSet) {
        ArrayList classNames = new ArrayList();
        changeSet.getChanges().forEach(change -> classNames.add(change.getClass().getSimpleName()));
        Collections.sort(classNames);
        return StringUtil.join(classNames, (String)"::");
    }

    private static void setupVariables(DynamicRule dynamicRule, List<LiquibaseRuleResult> results, Map<String, Boolean> variables, CheckSettingsConfig config, boolean isRollback) {
        dynamicRule.listChecksInChain().forEach(c -> {
            DynamicRule dr = config.getDynamicRuleByShortName((String)c);
            if (dr != null && dr.isChained()) {
                List<String> checks = dr.listChecksInChain();
                checks.forEach(innerCheck -> {
                    DynamicRule innerDynamic = config.getDynamicRuleByShortName((String)innerCheck);
                    if (innerDynamic != null && innerDynamic.isChained()) {
                        AbstractChainedChecksRule.setupVariables(innerDynamic, results, variables, config, isRollback);
                    } else {
                        AbstractChainedChecksRule.setupVariablesForCheck(innerCheck, results, variables, isRollback);
                    }
                });
            } else {
                AbstractChainedChecksRule.setupVariablesForCheck(c, results, variables, isRollback);
            }
        });
    }

    private static void setupVariablesForCheck(String checkName, List<LiquibaseRuleResult> results, Map<String, Boolean> variables, boolean isRollback) {
        results.stream().filter(r -> r.getRuleShortName(false).equalsIgnoreCase(checkName)).forEach(r -> {
            List iterations = r.getExecutions().stream().filter(e -> e.isRollback() == isRollback && !e.isSuccess()).collect(Collectors.toList());
            boolean result = !iterations.isEmpty();
            variables.put(checkName, result);
        });
    }

    private static void listAllChecksInChain(DynamicRule dynamicRule, CheckSettingsConfig config, List<String> checksInChain) {
        dynamicRule.listChecksInChain().forEach(c -> {
            DynamicRule dr = config.getDynamicRuleByShortName((String)c);
            if (dr != null && dr.isChained()) {
                List<String> checks = dr.listChecksInChain();
                checks.forEach(innerCheck -> {
                    DynamicRule innerDynamic = config.getDynamicRuleByShortName((String)innerCheck);
                    if (innerDynamic != null && innerDynamic.isChained()) {
                        AbstractChainedChecksRule.listAllChecksInChain(innerDynamic, config, checksInChain);
                    } else if (!checksInChain.contains(innerCheck)) {
                        checksInChain.add((String)innerCheck);
                    }
                });
            } else if (!checksInChain.contains(c)) {
                checksInChain.add((String)c);
            }
        });
    }

    private String getFailureMessage(String messageTemplate, String chainCheckName, String logicalCondition, Map<String, String> checkRuleResults) {
        StringBuilder builder = new StringBuilder();
        checkRuleResults.forEach((k, v) -> {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(String.format("'%s::%s'", k, v));
        });
        return messageTemplate.replace("<chained checks shortname>", chainCheckName).replace("<logic conditional>", logicalCondition).replace("<checknames>", builder.toString());
    }

    protected boolean execute(String logicalCondition, Map<String, Boolean> variables) {
        Serializable s = MVEL.compileExpression(logicalCondition, this.parserContext);
        return (Boolean)MVEL.executeExpression((Object)s, variables);
    }

    private static class ResultsChecker<T> {
        private boolean alreadyMatched = false;

        private ResultsChecker() {
        }

        public List<String> determineDisabledChecks(T key, Map<T, LiquibaseQualityCheckResult> results, List<String> checks) {
            if (!results.containsKey(key)) {
                return new ArrayList<String>();
            }
            List<AbstractConfigurableRule> configurableRules = results.get(key).getConfigurableRules();
            return checks.stream().filter(c -> configurableRules.stream().noneMatch(r -> r.isEnabled() && c.equalsIgnoreCase(r.getShortName()))).collect(Collectors.toList());
        }

        public List<String> determineNonApplicableChecks(T key, Map<T, LiquibaseQualityCheckResult> results, List<String> checks) {
            if (!results.containsKey(key)) {
                return new ArrayList<String>();
            }
            List<LiquibaseRuleResult> ruleResults = results.get(key).getRuleResults();
            return ruleResults.stream().filter(rr -> checks.contains(rr.getRuleShortName(false)) && rr.getExecutions().stream().anyMatch(e -> e.getFailureReason() == RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE)).map(rr -> rr.getRuleShortName(false)).collect(Collectors.toList());
        }

        private boolean resultsExist(String checkName, T object, Map<T, LiquibaseQualityCheckResult> results, boolean isRollback) {
            if (!results.containsKey(object)) {
                return false;
            }
            if (this.alreadyMatched) {
                return true;
            }
            List<LiquibaseRuleResult> ruleResults = results.get(object).getRuleResults();
            boolean b = ruleResults.stream().filter(rr -> rr.getRuleShortName(false).equalsIgnoreCase(checkName)).anyMatch(rr -> rr.getExecutions().stream().anyMatch(e -> e.isRollback() == isRollback && e.getFailureReason() == RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE));
            if (b) {
                return false;
            }
            this.alreadyMatched = ruleResults.stream().anyMatch(r -> r.getRuleShortName(false).equalsIgnoreCase(checkName));
            return this.alreadyMatched;
        }
    }
}

