/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.MissingPackageChangeGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.CreatePackageChange;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;

@LiquibaseService
public class MissingPackageExternalFileChangeGenerator
extends MissingPackageChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (!((Boolean)LiquibaseProConfiguration.INLINE_SQL_KEY.getCurrentValue()).booleanValue() && DatabasePackage.class.isAssignableFrom(objectType)) {
            return super.getPriority(objectType, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        Change[] changes = super.fixMissing(databaseObject, diffOutputControl, database, database2, changeGeneratorChain);
        CreatePackageChange change = (CreatePackageChange)changes[0];
        change.setRelativeToChangelogFile(true);
        change.setPath(ObjectSqlFileUtil.writeObjectSql((DatabasePackage)databaseObject));
        change.setPackageText(null);
        return changes;
    }
}

