/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.storedlogic.AbstractStoredDatabaseLogicSnapshotGenerator;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;

public class PostgresStoredProcedureSnapshotGenerator
extends AbstractStoredDatabaseLogicSnapshotGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof PostgresDatabase && !(database instanceof CockroachDatabase)) {
            try {
                int majorVersion = database.getDatabaseMajorVersion();
                if (majorVersion > 10) {
                    return super.getPriority(objectType, database);
                }
            }
            catch (Exception ignore) {
                return -1;
            }
        }
        return -1;
    }

    public PostgresStoredProcedureSnapshotGenerator() {
        super(StoredProcedure.class, new Class[]{Schema.class});
    }

    @Override
    protected String getObjectType(Database database) {
        return "PROCEDURE";
    }

    protected StoredDatabaseLogic<StoredProcedure> createReturnObject() {
        return new StoredProcedure();
    }

    @Override
    public String getAddToSql(Schema schema, Database database) {
        return String.format("select  pp.proname AS OBJECT_NAME, pp.proargnames AS OBJECT_ARG, pl.lanname as TYPE,'VALID' as STATUS, pg_get_functiondef(pp.oid) AS OBJECT_BODY \nfrom pg_proc pp \ninner join pg_namespace pn on (pp.pronamespace = pn.oid) inner join pg_language pl on (pp.prolang = pl.oid) where pn.nspname NOT LIKE 'pg_%%'   and pn.nspname = '%s'   and pp.prokind = 'p' ", schema.getName());
    }

    @Override
    public String getSnapshotObjectSql(StoredDatabaseLogic<?> storedDatabaseLogic, Database database) {
        String sql = this.getAddToSql(storedDatabaseLogic.getSchema(), database);
        sql = sql + " and pp.proname = '" + storedDatabaseLogic.getName() + "' ";
        return sql;
    }

    @Override
    public void addTo(DatabaseObject databaseObject, DatabaseSnapshot databaseSnapshot) throws DatabaseException {
        if (!(databaseObject instanceof Schema)) {
            return;
        }
        Schema schema = (Schema)databaseObject;
        Database database = databaseSnapshot.getDatabase();
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        List<Map<String, ?>> queryForListResult = this.queryForList(databaseSnapshot, schema, executor);
        for (Map<String, ?> row : queryForListResult) {
            String objectName = (String)row.get("OBJECT_NAME");
            String type = (String)row.get("TYPE");
            String objectBody = (String)row.get("OBJECT_BODY");
            StoredDatabaseLogic stoloObj = ((StoredProcedure)((StoredProcedure)this.createReturnObject().setSchema(schema)).setName(objectName)).setBody(objectBody);
            stoloObj.setAttribute("TYPE".toLowerCase(), (Object)type);
            schema.addDatabaseObject((DatabaseObject)stoloObj);
        }
    }

    @Override
    public StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database database, StoredDatabaseLogic<?> storedDatabaseLogicExample) throws DatabaseException {
        return storedDatabaseLogicExample;
    }
}

