/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.github.mustachejava.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import liquibase.repackaged.com.github.mustachejava.reflect.AbstractObjectHandler;

public abstract class BaseObjectHandler
extends AbstractObjectHandler {
    protected Field getField(Class aClass, String name) throws NoSuchFieldException {
        Field member;
        try {
            member = aClass.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            Class superclass = aClass.getSuperclass();
            if (superclass != null && superclass != Object.class) {
                return this.getField(superclass, name);
            }
            throw nsfe;
        }
        this.checkField(member);
        member.setAccessible(true);
        return member;
    }

    protected Method getMethod(Class<?> aClass, String name, Class<?> ... params) throws NoSuchMethodException {
        Method member;
        try {
            member = aClass.getMethod(name, params);
            if (member.getDeclaringClass() == Object.class) {
                throw new NoSuchMethodException();
            }
        }
        catch (NoSuchMethodException nsme) {
            try {
                member = aClass.getDeclaredMethod(name, params);
            }
            catch (NoSuchMethodException nsme2) {
                Class<?> superclass = aClass.getSuperclass();
                if (superclass != null && superclass != Object.class) {
                    return this.getMethod(superclass, name, new Class[0]);
                }
                throw nsme2;
            }
        }
        this.checkMethod(member);
        member.setAccessible(true);
        return member;
    }

    protected AccessibleObject findMember(Class sClass, String name) {
        if (String.class == sClass && "value".equals(name)) {
            return null;
        }
        if (this.checkClass(sClass)) {
            AccessibleObject ao;
            for (Class<?> anInterface : sClass.getInterfaces()) {
                AccessibleObject member = this.findMember(anInterface, name);
                if (member == null) continue;
                return member;
            }
            Class superclass = sClass.getSuperclass();
            if (superclass != null && superclass != Object.class && (ao = this.findMember(superclass, name)) != null) {
                return ao;
            }
        }
        return this.findMemberOnClass(sClass, name);
    }

    private AccessibleObject findMemberOnClass(Class sClass, String name) {
        AccessibleObject ao;
        if (name.isEmpty()) {
            return null;
        }
        try {
            ao = this.getMethod(sClass, name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String propertyname = name.substring(0, 1).toUpperCase() + (name.length() > 1 ? name.substring(1) : "");
            try {
                ao = this.getMethod(sClass, "get" + propertyname, new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                try {
                    ao = this.getMethod(sClass, "is" + propertyname, new Class[0]);
                }
                catch (NoSuchMethodException e3) {
                    try {
                        ao = this.getField(sClass, name);
                    }
                    catch (NoSuchFieldException e4) {
                        ao = null;
                    }
                }
            }
        }
        return ao;
    }

    protected void checkMethod(Method member) throws NoSuchMethodException {
        if ((member.getModifiers() & 2) == 2) {
            throw new NoSuchMethodException("Only public, protected and package members allowed");
        }
    }

    protected void checkField(Field member) throws NoSuchFieldException {
        if ((member.getModifiers() & 2) == 2) {
            throw new NoSuchFieldException("Only public, protected and package members allowed");
        }
    }

    protected boolean checkClass(Class sClass) {
        return (sClass.getModifiers() & 1) != 1;
    }
}

