/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.BasicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.StageEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseBasicRule;
import java.util.Collections;
import java.util.List;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class RequireOneChangePerChangeset
extends AbstractLiquibaseBasicRule {
    @Override
    public StageEnum getStage() {
        return StageEnum.FORECAST;
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, BasicRule basicRule) {
        if (this.hasOnlyOneChangeOrSqlStatement(changeSet)) {
            return this.putResultSuccessful(changeSet, true, (AbstractConfigurableRule)basicRule);
        }
        return this.putResultUnsuccessful(changeSet, "The changeset contains more than one change type or SQL statement. Changesets with multiple changes are discouraged to prevent partial execution of the changeset which requires more manual intervention to correct so that automation can proceed.", (AbstractConfigurableRule)basicRule);
    }

    private boolean hasOnlyOneChangeOrSqlStatement(ChangeSet changeset) {
        if (changeset.getChanges().size() > 1) {
            return false;
        }
        Change change = (Change)changeset.getChanges().get(0);
        if (!(change instanceof AbstractSQLChange)) {
            return true;
        }
        AbstractSQLChange sqlChange = (AbstractSQLChange)change;
        if (Boolean.FALSE.equals(sqlChange.isSplitStatements())) {
            return true;
        }
        String[] sqlStrings = StringUtil.processMultiLineSQL((String)sqlChange.getSql(), (boolean)true, (boolean)sqlChange.isSplitStatements(), (String)sqlChange.getEndDelimiter(), (ChangeSet)changeset);
        return sqlStrings.length == 1;
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, BasicRule basicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDescription() {
        return "This check enforces the Liquibase Best Practice of keeping individual changesets small by limiting them to one statement or change.";
    }

    @Override
    public String getShortName() {
        return "OneChangePerChangeset";
    }

    @Override
    public int getPriority() {
        return 180;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }

    @Override
    public String getName() {
        return "One Change Per Changeset";
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }
}

