/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.BasicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseBasicForecastRule;
import java.util.Collections;
import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RollbackContainer;
import liquibase.structure.DatabaseObject;

public class RollbackRequired
extends AbstractLiquibaseBasicForecastRule {
    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, BasicRule basicRule) {
        RollbackContainer rollbackContainer = changeSet.getRollback();
        if (rollbackContainer == null || rollbackContainer.getChanges().isEmpty()) {
            if (changeSet.getChanges() == null || changeSet.getChanges().isEmpty()) {
                return this.putResultSuccessful(changeSet, true, (AbstractConfigurableRule)basicRule);
            }
            if (!changeSet.getChanges().stream().allMatch(c -> c.supportsRollback(null))) {
                return this.putResultUnsuccessful(changeSet, "Liquibase recommends writing explicit rollback code for a changeset, where possible. While Liquibase does generate automatic rollback code for many changetypes, this check triggers when rollback code is not included.", (AbstractConfigurableRule)basicRule);
            }
            return this.putResultSuccessful(changeSet, true, (AbstractConfigurableRule)basicRule);
        }
        return this.putResultSuccessful(changeSet, true, (AbstractConfigurableRule)basicRule);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, BasicRule basicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDescription() {
        return "This check triggers when a changeset does not have a rollback defined.";
    }

    @Override
    public String getShortName() {
        return "RollbackRequired";
    }

    @Override
    public String getName() {
        return "Rollback Required for Changeset";
    }

    @Override
    public int getPriority() {
        return 160;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }
}

