/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.ChangesetAttributes;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.cli.StringEnumListGetter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.structure.DatabaseObject;

public abstract class AbstractChangesetAttributesRule
extends AbstractLiquibaseDynamicForecastRule {
    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public final boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        String attributeValue = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.ATTRIBUTE);
        String searchString = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.SEARCH_STRING);
        List<ChangesetAttributes> attributes = StringEnumListGetter.split(attributeValue, ChangesetAttributes.class, true);
        ArrayList<ChangesetAttributes> wrongAttributes = new ArrayList<ChangesetAttributes>();
        for (ChangesetAttributes attribute : attributes) {
            String changesetAttribute = String.valueOf(attribute.getValueGetter().apply(changeSet));
            if (changesetAttribute == null || this.equalityCheck(changesetAttribute, searchString)) continue;
            wrongAttributes.add(attribute);
        }
        if (!wrongAttributes.isEmpty()) {
            this.addFailureRuleIteration(changeSet, this.getFailureMessage(wrongAttributes, searchString), (AbstractConfigurableRule)dynamicRule);
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, false);
    }

    protected abstract boolean equalityCheck(String var1, String var2);

    protected abstract String getFailureMessage(List<ChangesetAttributes> var1, String var2);

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        return false;
    }

    @Override
    public abstract String getShortName();

    public abstract Class<?> getPermittedType();

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter<String>(DynamicRuleParameterEnum.ATTRIBUTE, (value, newParameterValues) -> {
            List<ChangesetAttributes> changesetAttributes = StringEnumListGetter.split(value, ChangesetAttributes.class, true);
            if (!this.allowMultipleAttributes() && changesetAttributes.size() > 1) {
                throw new IllegalArgumentException("Only one attribute is allowed for this rule");
            }
            boolean allMatch = changesetAttributes.stream().allMatch(attribute -> attribute.getType().isAssignableFrom(this.getPermittedType()));
            if (!allMatch) {
                throw new IllegalArgumentException("All attributes must be of type " + this.getPermittedType().getSimpleName());
            }
            return true;
        }, null){

            @Override
            public String getOptions() {
                return Arrays.toString(Arrays.stream(ChangesetAttributes.values()).filter(attribute -> attribute.getType().isAssignableFrom(AbstractChangesetAttributesRule.this.getPermittedType())).toArray(ChangesetAttributes[]::new));
            }
        }, new RuleParameter<Object>(DynamicRuleParameterEnum.SEARCH_STRING, (value, newParameterValues) -> {
            if (this.getPermittedType().isAssignableFrom(Boolean.class)) {
                String valueStr = String.valueOf(value);
                if ("true".equalsIgnoreCase(valueStr) || "false".equalsIgnoreCase(valueStr)) {
                    return true;
                }
                throw new IllegalArgumentException("Search string must be either 'true' or 'false'");
            }
            return true;
        }, null));
    }

    @Override
    public abstract String getDescription();

    public abstract boolean allowMultipleAttributes();

    @Override
    public abstract int getPriority();
}

