/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public abstract class AbstractRegexHelperCheck
extends AbstractLiquibaseDynamicForecastRule {
    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    private String getFailureMessage(String messageTemplate, String primarySearchString, String secondarySearchString, ChangeSet changeSet) {
        return messageTemplate.replace("<" + (Object)((Object)DynamicRuleParameterEnum.PATTERN_A) + ">", primarySearchString).replace("<" + (Object)((Object)DynamicRuleParameterEnum.PATTERN_B) + ">", secondarySearchString).replace("<CHANGESET>", changeSet.getId());
    }

    protected Boolean getCaseSensitiveParam(DynamicRule dynamicRule) {
        Boolean caseSensitive = (Boolean)DynamicRuleParameterEnum.CASE_SENSITIVE.defaultValue;
        if (dynamicRule.getParameterValue(DynamicRuleParameterEnum.CASE_SENSITIVE) != null) {
            caseSensitive = (Boolean)dynamicRule.getParameterValue(DynamicRuleParameterEnum.CASE_SENSITIVE);
        }
        return caseSensitive;
    }

    protected String getSql(Change change, Database database, boolean stripComments) {
        String sql = change instanceof AbstractSQLChange ? AbstractRegexHelperCheck.getSql((AbstractSQLChange)change) : AbstractRegexHelperCheck.generateSqlFromChange(change, database);
        if (stripComments) {
            sql = StringUtil.stripComments((String)sql);
        }
        if (StringUtil.isEmpty((String)sql)) {
            return null;
        }
        return sql;
    }

    @Override
    public int getPriority() {
        return 65;
    }

    protected int getFlags(boolean caseSensitive) {
        int flags = 40;
        if (!caseSensitive) {
            flags |= 2;
        }
        return flags;
    }

    protected boolean doCheck(Change change, Database database, String primarySearchString, String secondarySearchString, boolean stripComments, boolean caseSensitive, Direction direction, boolean shouldExist) throws IllegalStateException {
        String sql = this.getSql(change, database, stripComments);
        if (sql == null) {
            return false;
        }
        int flags = this.getFlags(caseSensitive);
        Pattern primaryPattern = Pattern.compile(".*?" + primarySearchString + ".*?", flags);
        if (!primaryPattern.matcher(sql).matches()) {
            return false;
        }
        Pattern pattern = direction == Direction.FORWARD ? Pattern.compile(".*?" + primarySearchString + ".*?" + secondarySearchString + ".*?", flags) : Pattern.compile(".*?" + secondarySearchString + ".*?" + primarySearchString + ".*?", flags);
        boolean found = pattern.matcher(sql).find();
        return shouldExist && found || !shouldExist && !found;
    }

    protected boolean doEvaluate(List<Change> changes, ChangeSet changeSet, DynamicRule dynamicRule, Database database, boolean isRollback, Direction direction, boolean shouldExist) {
        DynamicRuleParameter primarySearchStringParam = dynamicRule.getParameter(DynamicRuleParameterEnum.PATTERN_A);
        DynamicRuleParameter secondarySearchStringParam = dynamicRule.getParameter(DynamicRuleParameterEnum.PATTERN_B);
        DynamicRuleParameter messageParam = dynamicRule.getParameter(DynamicRuleParameterEnum.MESSAGE);
        if (primarySearchStringParam == null || secondarySearchStringParam == null || messageParam == null) {
            this.addFailureRuleIteration(changeSet, "This check requires manual intervention to update the checks-settings file, which will need to be integrated into your source control by an authorized user. Please run \"liquibase checks customize --checkname=" + dynamicRule.getShortName() + " --auto-update=on\" and accept the default values to enable liquibase to make the changes. To suppress this message, disable this check.", dynamicRule, isRollback);
            return this.returnAtEndOfRule(changeSet, dynamicRule, isRollback);
        }
        DynamicRuleParameter stripCommentsParam = dynamicRule.getParameter(DynamicRuleParameterEnum.STRIP_COMMENTS);
        Objects.requireNonNull(stripCommentsParam);
        String primarySearchString = (String)primarySearchStringParam.getValue();
        String secondarySearchString = (String)secondarySearchStringParam.getValue();
        String messageTemplate = (String)messageParam.getValue();
        Boolean stripComments = (Boolean)stripCommentsParam.getValue();
        Boolean caseSensitive = this.getCaseSensitiveParam(dynamicRule);
        for (Change change : changes) {
            try {
                if (!this.doCheck(change, database, primarySearchString, secondarySearchString, stripComments, caseSensitive, direction, shouldExist)) continue;
                this.addFailureRuleIteration(changeSet, this.getFailureMessage(messageTemplate, primarySearchString, secondarySearchString, changeSet), dynamicRule, isRollback);
            }
            catch (IllegalStateException ise) {
                Scope.getCurrentScope().getLog(AbstractRegexHelperCheck.class).info("Error generating SQL for change '" + change.getDescription() + "': " + ise.getMessage());
                this.addFailureRuleIteration(changeSet, "Unable to generate SQL for change '" + change.getDescription() + "'. Checks executed against the H2 database for this object type are not available.", (AbstractConfigurableRule)dynamicRule);
            }
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, isRollback);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.PATTERN_A), new RuleParameter(DynamicRuleParameterEnum.PATTERN_B), new RuleParameter(DynamicRuleParameterEnum.CASE_SENSITIVE), new RuleParameter(DynamicRuleParameterEnum.MESSAGE, null, null, this.getDefaultValueForMessage(), false), new RuleParameter(DynamicRuleParameterEnum.STRIP_COMMENTS));
    }

    public abstract String getDefaultValueForMessage();

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

