/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.MissingScriptResource;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.cli.StringEnumListGetter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.ScriptCommandStep;
import com.datical.liquibase.ext.rules.api.FactEnum;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.ScriptTypeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import com.datical.liquibase.ext.scripts.ScriptExecutor;
import com.datical.liquibase.ext.scripts.ScriptExecutorFactory;
import com.datical.liquibase.ext.scripts.ScriptReturnDTO;
import com.datical.liquibase.ext.util.CustomScriptUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.command.CommandResults;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.exception.ServiceNotFoundException;
import liquibase.logging.Logger;
import liquibase.resource.Resource;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.serializer.SnapshotSerializerFactory;
import liquibase.servicelocator.StandardServiceLocator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import lombok.Generated;

public class CustomCheck
extends AbstractLiquibaseDynamicForecastRule {
    public static final String STATUS_BINDING = "status_binding";
    public static final String DATABASE_BINDING = "database_binding";
    public static final String CHECKS_SCOPE_BINDING = "checksScope_binding";
    public static final String SCRIPT_MESSAGE_BINDING = "scriptMessage_binding";
    public static final String CHANGE_SET_BINDING = "changeSet_binding";
    public static final String CHANGES_BINDING = "changes_binding";
    public static final String DATABASE_OBJECT_BINDING = "databaseObject_binding";
    public static final String DATABASE_SNAPSHOT_BINDING = "databaseSnapshot_binding";
    public static final String CACHE_BINDING = "cache_binding";
    private String snapshotStringCache;
    private Map<String, Throwable> scriptsWithErrors = new LinkedHashMap<String, Throwable>();
    private ScriptExecutor scriptExecutorCache;
    public final Map<String, Object> checkScriptsCache = new HashMap<String, Object>();
    public static List<RuleParameter<?>> PARAMETERS = null;
    ScriptServiceLocator scriptServiceLocator = new ScriptServiceLocator();
    private Resource scriptResourceCache;

    @Override
    public String getName() {
        return "Custom Check Template";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Arrays.asList(ScopeEnum.CHANGELOG, ScopeEnum.DATABASE);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getShortName() {
        return "CustomCheckTemplate";
    }

    private boolean doEvaluate(List<Change> changes, ChangeSet changeSet, DynamicRule instance) {
        if (CustomCheck.isCorrectChecksScope(instance, ScopeEnum.CHANGELOG)) {
            if (!CustomCheck.isEnabled()) {
                this.addNonApplicableRuleIteration(changeSet, "Custom checks are disabled", RuleIteration.FailureReason.CUSTOM_CHECKS_DISABLED, (AbstractConfigurableRule)instance);
                return this.returnAtEndOfRule(changeSet, instance, false);
            }
            String scriptPath = (String)instance.getParameterValue(DynamicRuleParameterEnum.SCRIPT_PATH);
            Resource scriptResource = this.getResource(scriptPath);
            if (!scriptResource.exists()) {
                this.addNonApplicableRuleIteration(changeSet, "Could not find script", RuleIteration.FailureReason.SCRIPT_NOT_FOUND, (AbstractConfigurableRule)instance);
                return this.returnAtEndOfRule(changeSet, instance, false);
            }
            if (this.scriptsWithErrors.containsKey(scriptResource.getPath())) {
                return false;
            }
            String scriptArgs = (String)instance.getParameterValue(DynamicRuleParameterEnum.SCRIPT_ARGS);
            String scriptType = instance.getParameterValue(DynamicRuleParameterEnum.SCRIPT_TYPE).toString();
            ScriptReturnDTO returnDTO = new ScriptReturnDTO();
            SimpleBindings bindings = new SimpleBindings();
            bindings.put(STATUS_BINDING, (Object)returnDTO);
            Database database = Scope.getCurrentScope().getDatabase();
            DatabaseSnapshot snapshot = (DatabaseSnapshot)Scope.getCurrentScope().get(FactEnum.DATABASE_SNAPSHOT.toString(), DatabaseSnapshot.class);
            if (this.snapshotStringCache == null && snapshot != null) {
                this.snapshotStringCache = SnapshotSerializerFactory.getInstance().getSerializer("json").serialize((LiquibaseSerializable)snapshot, true);
            }
            bindings.put(DATABASE_SNAPSHOT_BINDING, (Object)this.snapshotStringCache);
            bindings.put(DATABASE_BINDING, (Object)database);
            bindings.put(CHECKS_SCOPE_BINDING, (Object)ScopeEnum.CHANGELOG.toString());
            bindings.put(SCRIPT_MESSAGE_BINDING, instance.getParameterValue(DynamicRuleParameterEnum.SCRIPT_MESSAGE));
            bindings.put(CHANGE_SET_BINDING, (Object)changeSet);
            bindings.put(CHANGES_BINDING, (Object)changes);
            bindings.put(CACHE_BINDING, (Object)this.checkScriptsCache);
            try {
                CommandScope commandScope = this.initCommandScope(scriptPath, scriptArgs, scriptType, scriptResource, bindings);
                Scope.child((String)"DO_NOT_SEND_EXCEPTION_TO_UI", (Object)true, () -> {
                    CommandResults results = commandScope.execute();
                    Boolean returnValue = (Boolean)results.getResult("returnValue");
                    if (Boolean.TRUE.equals(returnValue) && returnDTO.fired) {
                        this.addFailureRuleIteration(changeSet, returnDTO.message, instance, false);
                    }
                });
            }
            catch (Exception e) {
                String message = e.getMessage();
                message = message.replace("liquibase.exception.LiquibaseException:", "").trim();
                this.putResultUnsuccessful(changeSet, message, (AbstractConfigurableRule)instance, RuleIteration.FailureReason.SCRIPT_HAS_ERROR);
                this.scriptsWithErrors.put(scriptResource.getPath(), e);
            }
        }
        return this.returnAtEndOfRule(changeSet, instance, false);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, Database database, DynamicRule dynamicRule) {
        return this.internalEvaluate(changeSet, dynamicRule);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule instance) {
        return this.doEvaluate(changeSet.getChanges(), changeSet, instance);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, Database database, DynamicRule dr) {
        return this.doEvaluate(changes, changeSet, dr);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule instance) {
        if (CustomCheck.isCorrectChecksScope(instance, ScopeEnum.DATABASE)) {
            if (!CustomCheck.isEnabled()) {
                this.addNonApplicableRuleIteration(databaseObject, "Custom checks are disabled", RuleIteration.FailureReason.CUSTOM_CHECKS_DISABLED, (AbstractConfigurableRule)instance);
                return this.returnAtEndOfRule(databaseObject, (AbstractConfigurableRule)instance);
            }
            String scriptPath = (String)instance.getParameterValue(DynamicRuleParameterEnum.SCRIPT_PATH);
            Resource scriptResource = this.getResource(scriptPath);
            if (!scriptResource.exists()) {
                this.addNonApplicableRuleIteration(databaseObject, "Could not find script", RuleIteration.FailureReason.SCRIPT_NOT_FOUND, (AbstractConfigurableRule)instance);
                return this.returnAtEndOfRule(databaseObject, (AbstractConfigurableRule)instance);
            }
            if (this.scriptsWithErrors.containsKey(scriptResource.getPath())) {
                return false;
            }
            String scriptType = instance.getParameterValue(DynamicRuleParameterEnum.SCRIPT_TYPE).toString();
            ScriptReturnDTO returnDTO = new ScriptReturnDTO();
            SimpleBindings bindings = new SimpleBindings();
            bindings.put(STATUS_BINDING, (Object)returnDTO);
            bindings.put(DATABASE_OBJECT_BINDING, (Object)databaseObject);
            Database database = (Database)Scope.getCurrentScope().get(FactEnum.DATABASE.toString(), Database.class);
            bindings.put(DATABASE_BINDING, (Object)database);
            bindings.put(CHECKS_SCOPE_BINDING, (Object)ScopeEnum.DATABASE.toString());
            bindings.put(SCRIPT_MESSAGE_BINDING, instance.getParameterValue(DynamicRuleParameterEnum.SCRIPT_MESSAGE));
            bindings.put(CACHE_BINDING, (Object)this.checkScriptsCache);
            DatabaseSnapshot snapshot = (DatabaseSnapshot)Scope.getCurrentScope().get(FactEnum.DATABASE_SNAPSHOT.toString(), DatabaseSnapshot.class);
            if (this.snapshotStringCache == null) {
                this.snapshotStringCache = SnapshotSerializerFactory.getInstance().getSerializer("json").serialize((LiquibaseSerializable)snapshot, true);
            }
            bindings.put(DATABASE_SNAPSHOT_BINDING, (Object)this.snapshotStringCache);
            String scriptArgs = (String)instance.getParameterValue(DynamicRuleParameterEnum.SCRIPT_ARGS);
            try {
                CommandScope commandScope = this.initCommandScope(scriptPath, scriptArgs, scriptType, scriptResource, bindings);
                Scope.child((String)"DO_NOT_SEND_EXCEPTION_TO_UI", (Object)true, () -> {
                    CommandResults results = commandScope.execute();
                    Boolean returnValue = (Boolean)results.getResult("returnValue");
                    if (Boolean.TRUE.equals(returnValue) && returnDTO.fired) {
                        this.addFailureRuleIteration(databaseObject, returnDTO.message, (AbstractConfigurableRule)instance);
                    }
                });
            }
            catch (Exception e) {
                String message = e.getMessage();
                message = message.replace("liquibase.exception.LiquibaseException:", "").trim();
                this.putResultUnsuccessful(databaseObject, message, (AbstractConfigurableRule)instance, RuleIteration.FailureReason.SCRIPT_HAS_ERROR);
                this.scriptsWithErrors.put(scriptResource.getPath(), e);
            }
        }
        return this.returnAtEndOfRule(databaseObject, (AbstractConfigurableRule)instance);
    }

    @Override
    public String getDescription() {
        return "Executes a custom check script.";
    }

    @Override
    public int getPriority() {
        return 81;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return PARAMETERS;
    }

    @Override
    public void resetRuleCaches() {
        this.snapshotStringCache = null;
        if (this.scriptExecutorCache != null) {
            try {
                this.scriptExecutorCache.close();
            }
            catch (Exception e) {
                Scope.getCurrentScope().getLog(CustomCheck.class).warning("Problem occurred while closing context: " + e.getMessage());
            }
            this.scriptExecutorCache = null;
        }
    }

    private ScriptExecutor createScriptExecutor(String scriptPath, String scriptType, Bindings bindings) throws Exception {
        if (this.scriptExecutorCache != null) {
            this.scriptExecutorCache.setBindings(bindings);
            return this.scriptExecutorCache;
        }
        String actualScriptType = ScriptCommandStep.determineScriptType(scriptType, scriptPath);
        ScriptExecutorFactory scriptExecutorFactory = (ScriptExecutorFactory)Scope.getCurrentScope().getSingleton(ScriptExecutorFactory.class);
        Scope.child((Enum)Scope.Attr.serviceLocator, (Object)((Object)this.scriptServiceLocator), () -> {
            this.scriptExecutorCache = scriptExecutorFactory.getScriptExecutor(actualScriptType, bindings);
        });
        if (this.scriptServiceLocator.getServiceLoaderErrors().containsKey(ScriptExecutor.class.getName())) {
            Throwable t = this.scriptServiceLocator.getServiceLoaderErrors().get(ScriptExecutor.class.getName());
            if (t.getCause() != null && t.getCause().getMessage() != null && t.getCause().getMessage().contains("has been compiled by a more recent version of the Java Runtime")) {
                throw new RuntimeException("Custom Policy Checks require Java 17 or higher");
            }
            throw new RuntimeException("Error loading script executor", t);
        }
        return this.scriptExecutorCache;
    }

    public static boolean isCorrectChecksScope(DynamicRule instance, ScopeEnum currentScope) {
        String scriptScope = (String)instance.getParameterValue(DynamicRuleParameterEnum.SCRIPT_SCOPE);
        List<ScopeEnum> scopes = StringEnumListGetter.split(scriptScope, ScopeEnum.class, true);
        return scopes.contains((Object)currentScope);
    }

    private CommandScope initCommandScope(String scriptPath, String scriptArgs, String scriptType, Resource scriptResource, Bindings bindings) throws Exception {
        ScriptExecutor scriptExecutor = this.createScriptExecutor(scriptPath, scriptType, bindings);
        if (scriptExecutor == null) {
            throw new RuntimeException("No script executor found for script type '" + scriptType + "'");
        }
        CommandScope commandScope = new CommandScope(ScriptCommandStep.COMMAND_NAME);
        commandScope.addArgumentValue(ScriptCommandStep.SCRIPT_PATH_ARG, (Object)scriptPath);
        commandScope.addArgumentValue(ScriptCommandStep.SCRIPT_ARGS, (Object)scriptArgs);
        commandScope.addArgumentValue(ScriptCommandStep.SCRIPT_TYPE_ARG, (Object)scriptType);
        commandScope.addArgumentValue(ScriptCommandStep.RESOURCE_ARG, (Object)scriptResource);
        commandScope.addArgumentValue(ScriptCommandStep.BINDINGS_ARG.getName(), (Object)bindings);
        commandScope.addArgumentValue(ScriptCommandStep.SCRIPT_EXECUTOR_ARG, (Object)scriptExecutor);
        commandScope.addArgumentValue(ScriptCommandStep.RUNNING_IN_CHECKS_COMMAND, (Object)true);
        return commandScope;
    }

    private Resource getResource(String scriptPath) {
        if (this.getScriptResourceCache() != null) {
            return this.getScriptResourceCache();
        }
        try {
            Resource scriptResource = CustomScriptUtil.getScriptResource(scriptPath, null);
            this.setScriptResourceCache(scriptResource);
            return scriptResource;
        }
        catch (Exception ignored) {
            MissingScriptResource missingScriptResource = new MissingScriptResource(scriptPath);
            this.setScriptResourceCache(missingScriptResource);
            return missingScriptResource;
        }
    }

    private static boolean isEnabled() {
        return CustomScriptUtil.getCustomScriptArguments(null).getEnabled();
    }

    @Generated
    public Resource getScriptResourceCache() {
        return this.scriptResourceCache;
    }

    @Generated
    public void setScriptResourceCache(Resource scriptResourceCache) {
        this.scriptResourceCache = scriptResourceCache;
    }

    static {
        PARAMETERS = Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.SCRIPT_DESCRIPTION, null, null, "Custom check", true), new RuleParameter(DynamicRuleParameterEnum.SCRIPT_SCOPE, null, null, null, false), new RuleParameter(DynamicRuleParameterEnum.SCRIPT_MESSAGE, null, null, null, true), new RuleParameter<DynamicRuleParameterEnum>(DynamicRuleParameterEnum.SCRIPT_TYPE, null, null, null, true){

            @Override
            public Object getDefaultValue() {
                ArrayList newParameterValues = (ArrayList)Scope.getCurrentScope().get("newParameterValues", List.class);
                if (newParameterValues == null) {
                    newParameterValues = new ArrayList();
                }
                for (DynamicRuleParameter param : newParameterValues) {
                    if (!param.getParameter().equals(DynamicRuleParameterEnum.SCRIPT_PATH.name())) continue;
                    String scriptPath = (String)param.getValue();
                    if (!(scriptPath = scriptPath.toLowerCase()).endsWith(".py") && !scriptPath.endsWith(".python")) continue;
                    return ScriptTypeEnum.PYTHON;
                }
                return ScriptTypeEnum.PYTHON;
            }
        }, new RuleParameter(DynamicRuleParameterEnum.SCRIPT_PATH), new RuleParameter(DynamicRuleParameterEnum.SCRIPT_ARGS, null, null, null, true), new RuleParameter(DynamicRuleParameterEnum.REQUIRES_SNAPSHOT, null, null, null, false));
    }

    public static class ScriptServiceLocator
    extends StandardServiceLocator {
        private final Map<String, Throwable> serviceLoaderErrors = new HashMap<String, Throwable>();

        public <T> List<T> findInstances(Class<T> interfaceType) throws ServiceNotFoundException {
            ArrayList<T> allInstances = new ArrayList<T>();
            Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
            Iterator<T> services = ServiceLoader.load(interfaceType, Scope.getCurrentScope().getClassLoader(true)).iterator();
            while (services.hasNext()) {
                try {
                    T service = services.next();
                    log.fine("Loaded " + interfaceType.getName() + " instance " + service.getClass().getName());
                    allInstances.add(service);
                }
                catch (Throwable e) {
                    this.serviceLoaderErrors.put(interfaceType.getName(), e);
                }
            }
            return Collections.unmodifiableList(allInstances);
        }

        @Generated
        public Map<String, Throwable> getServiceLoaderErrors() {
            return this.serviceLoaderErrors;
        }
    }
}

