/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.OperatorEnum;
import com.datical.liquibase.ext.checks.dynamic.AbstractChangeSetParameterRegexCheck;
import java.util.Optional;
import java.util.Set;
import liquibase.changelog.ChangeSet;

public class UserDefinedContextCheck
extends AbstractChangeSetParameterRegexCheck {
    public static final String INVALID_LABEL_MESSAGE_TEMPLATE = "Changeset context: '%s' did not match the pattern: %s '%s'. Please review this context.";

    @Override
    public String getErrorMessage(String parameter, OperatorEnum operator, String searchString) {
        return String.format(INVALID_LABEL_MESSAGE_TEMPLATE, parameter, operator.displayName, searchString);
    }

    @Override
    public Set<String> getChangeSetParameters(ChangeSet changeSet) {
        return changeSet.getContextFilter().getContexts();
    }

    @Override
    public Optional<String> getAssembledChangeSetParameters(ChangeSet changeSet) {
        return Optional.ofNullable(changeSet.getContextFilter().getOriginalString());
    }

    @Override
    public String getSimpleName() {
        return "Contexts";
    }

    @Override
    public String getDescription() {
        return "This check confirms that a specific context or a context that matches a specific pattern is present on all changesets.";
    }

    @Override
    public String getShortName() {
        return "UserDefinedContextCheck";
    }

    @Override
    public String getName() {
        return "Check for User Defined Context";
    }

    @Override
    public int getPriority() {
        return 221;
    }
}

