/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.config.ExtendedLiquibaseCommandLineConfiguration;
import com.datical.liquibase.ext.logging.custommdc.CustomLogDataFile;
import com.datical.liquibase.ext.reports.ReportArguments;
import com.datical.liquibase.ext.reports.ReportUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import liquibase.Scope;
import liquibase.command.CommandResultsBuilder;
import liquibase.configuration.ConfiguredValue;
import liquibase.integration.IntegrationDetails;
import liquibase.logging.mdc.MdcManager;
import liquibase.report.UpdateRollbackReportParameters;

public abstract class AbstractUpdateRollbackReportGenerator<T extends UpdateRollbackReportParameters> {
    public void run(T report, ReportArguments arguments) {
        if (arguments == null || arguments.ignoreReport()) {
            return;
        }
        this.setRuntimeInfo(report);
        this.setOperationInfo(report);
        this.setCustomDateFile(report);
        String reportName = arguments.getName();
        LocalDateTime timeNow = LocalDateTime.now();
        if (reportName.contains("dd-MMM-yyyy-HHmmss")) {
            reportName = reportName.replace("dd-MMM-yyyy-HHmmss", arguments.buildReportDateFormat(timeNow));
        }
        String reportPath = arguments.getPath();
        this.generateReport(reportName, reportPath, report);
    }

    public void run(CommandResultsBuilder resultsBuilder, ReportArguments arguments) throws Exception {
        UpdateRollbackReportParameters report = (UpdateRollbackReportParameters)resultsBuilder.getResult(this.getResultsBuilderReportKey());
        this.run(report, arguments);
    }

    public abstract void generateReport(String var1, String var2, T var3);

    public abstract String getResultsBuilderReportKey();

    public abstract String[] getCommandName();

    private void setRuntimeInfo(T reportParameters) {
        MdcManager mdcManager = Scope.getCurrentScope().getMdcManager();
        Map mdc = mdcManager.getAll();
        String startTime = String.valueOf(mdc.get("operationStart"));
        reportParameters.getRuntimeInfo().setUpdateDuration(this.determineDuration(startTime));
        reportParameters.getRuntimeInfo().setStartTime(startTime);
        IntegrationDetails integrationDetails = (IntegrationDetails)Scope.getCurrentScope().get("integrationDetails", IntegrationDetails.class);
        if (integrationDetails != null) {
            reportParameters.getRuntimeInfo().setInterfaceType(integrationDetails.getName());
        }
    }

    private void setOperationInfo(T reportParameters) {
        reportParameters.getOperationInfo().setCommand(ReportUtils.getDisplayArgs((String[])Scope.getCurrentScope().get("commandArguments", String[].class)));
    }

    private void setCustomDateFile(T reportParameters) {
        ConfiguredValue customLogDataFileCurrentConfiguredValue = ExtendedLiquibaseCommandLineConfiguration.CUSTOM_LOG_DATA_FILE.getCurrentConfiguredValue();
        reportParameters.getCustomData().setCustomDataFile((String)customLogDataFileCurrentConfiguredValue.getValue());
        if (customLogDataFileCurrentConfiguredValue.found()) {
            try {
                Map<String, Object> customLogDataFileContents = CustomLogDataFile.getFileContents();
                reportParameters.getCustomData().setFileContents(customLogDataFileContents);
            }
            catch (Exception exception) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("Could not set custom log data information for report.", (Throwable)exception);
            }
        }
    }

    private String determineDuration(String startTime) {
        try {
            Instant startTimeInstant = Instant.parse(startTime);
            Instant now = Instant.now();
            long durationMilli = now.minusMillis(startTimeInstant.toEpochMilli()).toEpochMilli();
            long hours = TimeUnit.MILLISECONDS.toHours(durationMilli);
            long minute = TimeUnit.MILLISECONDS.toMinutes(durationMilli) - TimeUnit.HOURS.toMinutes(hours);
            long second = TimeUnit.MILLISECONDS.toSeconds(durationMilli) - TimeUnit.HOURS.toSeconds(hours) - TimeUnit.MINUTES.toSeconds(minute);
            long ms = TimeUnit.MILLISECONDS.toMillis(durationMilli) - TimeUnit.HOURS.toMillis(hours) - TimeUnit.MINUTES.toMillis(minute) - TimeUnit.SECONDS.toMillis(second);
            return String.format("%d hours %d mins %d secs %d ms", hours, minute, second, ms);
        }
        catch (Exception ignored) {
            return "UNKNOWN";
        }
    }
}

