/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigYaml;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.CommandExecutionException;
import liquibase.logging.Logger;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.util.CollectionUtil;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.nodes.Tag;

public class ChecksCreateCommandStep
extends AbstractChecksCommandStep {
    private static final String[] COMMAND_NAME = new String[]{"checks", "create"};
    public static final CommandArgumentDefinition<String> PACKAGE_FILE;
    public static final CommandArgumentDefinition<String> PACKAGE_NAME;
    public static final CommandArgumentDefinition<String> PACKAGE_CONTENTS;
    public static final CommandArgumentDefinition<Boolean> RECURSIVE;
    private static final CheckSettingsConfigYaml yaml;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String checksPackageFilename = (String)commandScope.getArgumentValue(PACKAGE_FILE);
        String checksPackageName = (String)commandScope.getArgumentValue(PACKAGE_NAME);
        String checksPackageSettingsPath = (String)commandScope.getArgumentValue(PACKAGE_CONTENTS);
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        List<Resource> requestedFiles = this.findAllRequestedFiles(commandScope, checksPackageSettingsPath, checksPackageFilename);
        log.fine("Found " + requestedFiles.size() + " files to add in path " + checksPackageSettingsPath);
        Resource existingChecksPackageFile = resourceAccessor.get(checksPackageFilename);
        if (existingChecksPackageFile.exists()) {
            LinkedHashMap checksMap;
            log.fine("Checks package file " + checksPackageFilename + " exists, appending.");
            try (InputStream checksPackageFileInputStream = existingChecksPackageFile.openInputStream();){
                checksMap = (LinkedHashMap)yaml.load(checksPackageFileInputStream);
            }
            var13_13 = null;
            try (OutputStream checksPackageFileOutputStream = pathHandlerFactory.openResourceOutputStream(checksPackageFilename, new OpenOptions().setCreateIfNeeded(false));){
                checksPackageFileOutputStream.write(this.buildPackage(requestedFiles, checksPackageName, checksMap).getBytes());
            }
            catch (Throwable throwable) {
                var13_13 = throwable;
                throw throwable;
            }
            Scope.getCurrentScope().getUI().sendMessage(this.buildSuccessMessage(checksPackageFilename, true, checksPackageSettingsPath, checksPackageName, requestedFiles));
        } else {
            log.fine("Checks package file " + checksPackageFilename + " does not exist, creating.");
            try (OutputStream checksPackageFileOutputStream = pathHandlerFactory.createResource(checksPackageFilename);){
                checksPackageFileOutputStream.write(this.buildPackage(requestedFiles, checksPackageName).getBytes());
            }
            Scope.getCurrentScope().getUI().sendMessage(this.buildSuccessMessage(checksPackageFilename, false, checksPackageSettingsPath, checksPackageName, requestedFiles));
        }
    }

    private String buildSuccessMessage(String checksPackageFilename, boolean exists, String checksPackageSettingsPath, String checksPackageName, List<Resource> requestedFiles) {
        String pluralize = requestedFiles.size() > 1 ? "s" : "";
        return String.format("INFO: SUCCESS! '%s' was %s, and the specified file%s at '%s' were added to %s checks package named '%s'. Use this checks package with 'liquibase checks show --checks-settings-file=%s --checks-packages=%s'", checksPackageFilename, exists ? "updated" : "created", pluralize, checksPackageSettingsPath, exists ? "existing" : "new", checksPackageName, checksPackageFilename, checksPackageName);
    }

    private String buildPackage(List<Resource> files, String packageName) {
        return this.buildPackage(files, packageName, new LinkedHashMap<String, List<LinkedHashMap<String, Object>>>());
    }

    private String buildPackage(List<Resource> files, String packageName, LinkedHashMap<String, List<LinkedHashMap<String, Object>>> existingPackageFile) {
        ArrayList<String> foundFiles = new ArrayList<String>(files.size());
        for (Resource requestedFile : files) {
            String path = requestedFile.getPath();
            if (foundFiles.contains(path)) continue;
            foundFiles.add(path);
        }
        LinkedHashMap<String, Object> thePackage = new LinkedHashMap<String, Object>();
        thePackage.put("name", packageName);
        thePackage.put("files", foundFiles);
        String checksPackagesKey = CollectionUtil.findKeyInMapIgnoreCase((String)"checksPackages", existingPackageFile);
        if (StringUtil.isNotEmpty((String)checksPackagesKey)) {
            List<LinkedHashMap<String, Object>> packages = existingPackageFile.get(checksPackagesKey);
            boolean foundMatchingPackage = false;
            for (LinkedHashMap<String, Object> aPackage : packages) {
                String nameKey;
                String name = String.valueOf(aPackage.get(nameKey = CollectionUtil.findKeyInMapIgnoreCase((String)"name", aPackage)));
                if (!name.equals(packageName)) continue;
                foundMatchingPackage = true;
                String filesKey = CollectionUtil.findKeyInMapIgnoreCase((String)"files", aPackage);
                List existingFiles = (List)aPackage.get(filesKey);
                for (String foundFile : foundFiles) {
                    if (existingFiles.contains(foundFile)) continue;
                    existingFiles.add(foundFile);
                }
            }
            if (!foundMatchingPackage) {
                packages.add(thePackage);
            }
        } else {
            existingPackageFile.put("checksPackages", Collections.singletonList(thePackage));
        }
        return yaml.dumpAs(existingPackageFile, Tag.MAP, DumperOptions.FlowStyle.BLOCK);
    }

    private List<Resource> findAllRequestedFiles(CommandScope commandScope, String checksPackageSettingsPath, String checksPackageFilename) throws IOException, CommandExecutionException {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        List pathsToSearch = StringUtil.splitAndTrim((String)checksPackageSettingsPath, (String)",");
        ArrayList<Resource> foundResources = new ArrayList<Resource>();
        for (String toSearch : pathsToSearch) {
            Resource resource = resourceAccessor.get(toSearch);
            if (!resource.exists()) {
                throw new CommandExecutionException(String.format("ERROR: The checks-settings-file '%s' could not be found. No file named '%s' created or updated. Please check path, filename, or permissions. Learn more at https://docs.liquibase.com/quality-checks", checksPackageSettingsPath, checksPackageFilename));
            }
            try {
                List search = resourceAccessor.search(toSearch, ((Boolean)commandScope.getArgumentValue(RECURSIVE)).booleanValue());
                search.sort(Comparator.comparing(Resource::getPath));
                foundResources.addAll(search);
            }
            catch (Exception e) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Unable to search checksPackageSettingsPath segment: " + toSearch + ". Perhaps it is a file not a directory.", (Throwable)e);
                foundResources.add(resource);
            }
        }
        return foundResources;
    }

    static {
        yaml = new CheckSettingsConfigYaml();
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        PACKAGE_FILE = builder.argument("packageFile", String.class).addForcePrintAlias("checksPackageFile").addAlias("checksPackagesFile").description("Relative or fully qualified path and filename of the checks-package file to be created").defaultValue((Object)"liquibase.checks-package.yaml").build();
        PACKAGE_NAME = builder.argument("packageName", String.class).description("The literal name of the checks-package object to be created inside the checks-package yaml file").required().build();
        PACKAGE_CONTENTS = builder.argument("packageContents", String.class).addAlias("packageContentFile").addForcePrintAlias("packageContentFiles").addAlias("packageContentsFile").addAlias("packageContentsFiles").description("One or more comma-separated relative path(s) to the checks-settings files (or to a directory of files) to be bundled into the checks-package. If the value is a directory, all files will be added to the 'checks-package-name' object, but not recursively.").required().build();
        RECURSIVE = builder.argument("recursive", Boolean.class).defaultValue((Object)false).hidden().description("If true, will search through directories recursively. If checksPackageSettingsPath is a file, this setting has no effect.").build();
    }
}

