/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.provider;

import com.datical.liquibase.ext.flow.provider.AbstractFlowGlobalArgsValueProvider;
import com.datical.liquibase.ext.logging.structured.StructuredLogService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import liquibase.Scope;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.logging.LogFormat;
import liquibase.logging.LogService;
import liquibase.logging.core.JavaLogService;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;

public class ActionGlobalArgsValueProvider
extends AbstractFlowGlobalArgsValueProvider {
    private int precedence = 380;
    private Handler fileHandler;
    private Handler previousHandler;

    public ActionGlobalArgsValueProvider(Map<String, Object> globalMap) {
        super(globalMap);
        LiquibaseConfiguration liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
        SortedSet valueProviders = liquibaseConfiguration.getProviders();
        int count = 0;
        for (ConfigurationValueProvider valueProvider : valueProviders) {
            if (!(valueProvider instanceof ActionGlobalArgsValueProvider)) continue;
            ++count;
        }
        if (count > 0) {
            this.precedence += count;
        }
        if (globalMap != null) {
            try {
                String levelString = (String)this.getValueWithFuzzyMatching("loglevel", globalMap);
                Level level = Level.OFF;
                level = levelString != null ? Level.parse(levelString) : Level.INFO;
                String logFile = (String)this.getValueWithFuzzyMatching("logfile", globalMap);
                String logFormat = (String)this.getValueWithFuzzyMatching("logFormat", globalMap);
                if (logFormat != null && StructuredLogService.isStructuredLogFormat(logFormat)) {
                    HashMap<String, Object> scopedValues = new HashMap<String, Object>();
                    scopedValues.put("liquibase.logFormat", logFormat);
                    scopedValues.put(Scope.Attr.logService.name(), (Object)new StructuredLogService());
                    Level finalLevel = level;
                    try {
                        Scope.child(scopedValues, () -> this.configureLogging(finalLevel, logFile));
                    }
                    catch (Exception e) {
                        this.configureLogging(level, logFile);
                    }
                } else {
                    this.configureLogging(level, logFile);
                }
            }
            catch (IOException ioe) {
                Scope.getCurrentScope().getLog(ActionGlobalArgsValueProvider.class).info("Unable to configuration logging for flow command", (Throwable)ioe);
            }
        }
    }

    private Object getValueWithFuzzyMatching(String keyToMatch, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key == null || !(key = key.replace("-", "")).equalsIgnoreCase(keyToMatch = keyToMatch.replace("-", ""))) continue;
            return map.get(entry.getKey());
        }
        return null;
    }

    public void removeHandler() {
        if (this.fileHandler != null) {
            Logger rootLogger = Logger.getLogger("");
            this.fileHandler.close();
            rootLogger.removeHandler(this.fileHandler);
            if (this.previousHandler != null) {
                rootLogger.addHandler(this.previousHandler);
            }
        }
    }

    private void configureLogging(Level logLevel, String logFile) throws IOException {
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        LogService logService = (LogService)Scope.getCurrentScope().get((Enum)Scope.Attr.logService, LogService.class);
        Logger liquibaseLogger = Logger.getLogger("liquibase");
        liquibaseLogger.setLevel(logLevel);
        if (logService instanceof JavaLogService) {
            ((JavaLogService)logService).setParent(liquibaseLogger);
        }
        Logger rootLogger = Logger.getLogger("");
        if (logFile != null) {
            OutputStream outputStream = pathHandlerFactory.openResourceOutputStream(logFile, new OpenOptions().setAppend(true));
            this.fileHandler = new StreamHandler(outputStream, new SimpleFormatter());
            if (Scope.getCurrentScope().get("liquibase.logFormat", LogFormat.class) != null) {
                JavaLogService.setFormatterOnHandler((LogService)logService, (Handler)this.fileHandler);
            }
            Handler[] handlers = rootLogger.getHandlers();
            this.previousHandler = handlers[handlers.length - 1];
            if (!(this.previousHandler instanceof ConsoleHandler)) {
                rootLogger.removeHandler(this.previousHandler);
            } else {
                this.previousHandler = null;
            }
            rootLogger.addHandler(this.fileHandler);
            this.fileHandler.setLevel(logLevel);
        }
    }

    public ActionGlobalArgsValueProvider(Map<String, Object> globalMap, int newPrecedence) {
        super(globalMap);
        this.precedence += newPrecedence;
    }

    public int getPrecedence() {
        return this.precedence;
    }
}

