/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.logging.custommdc;

import java.util.concurrent.Callable;
import lombok.Generated;

public class Cache<T> {
    private T value;
    private final Callable<T> generator;
    private boolean generated = false;
    private boolean exceptionIsPermitted = false;
    private Exception exception;

    public Cache(Callable<T> generator) {
        this.generator = generator;
    }

    public Cache(Callable<T> generator, boolean exceptionIsPermitted) {
        this.generator = generator;
        this.exceptionIsPermitted = exceptionIsPermitted;
    }

    public T get() throws Exception {
        if (!this.generated) {
            try {
                this.value = this.generator.call();
            }
            catch (Exception e) {
                if (this.exceptionIsPermitted) {
                    this.exception = e;
                    this.generated = true;
                }
                throw e;
            }
            this.generated = true;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    public void clearCache() {
        this.generated = false;
    }

    @Generated
    public boolean isGenerated() {
        return this.generated;
    }
}

