/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.databasepackage.ChangedPackageChangeGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.CreatePackageChange;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;

@LiquibaseService
public class ChangedPackageExternalFileChangeGenerator
extends ChangedPackageChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (!((Boolean)LiquibaseProConfiguration.INLINE_SQL_KEY.getCurrentValue()).booleanValue() && DatabasePackage.class.isAssignableFrom(objectType)) {
            return super.getPriority(objectType, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixChanged(DatabaseObject databaseObject, ObjectDifferences objectDifferences, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        Change[] changes = super.fixChanged(databaseObject, objectDifferences, diffOutputControl, database, database2, changeGeneratorChain);
        if (changes == null) {
            return null;
        }
        CreatePackageChange change = (CreatePackageChange)changes[0];
        String packageName = change.getPackageName();
        String text = change.getPackageText();
        change.setRelativeToChangelogFile(true);
        change.setPath(ObjectSqlFileUtil.writeObjectSql((DatabasePackage)databaseObject));
        change.setPackageText(null);
        return changes;
    }
}

