/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage;

import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackageBody;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.CreatePackageBodyChange;
import com.datical.liquibase.ext.storedlogic.function.Function;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;

public class MissingPackageBodyChangeGenerator
extends AbstractMissingStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (DatabasePackageBody.class.isAssignableFrom(objectType)) {
            return 101;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Function.class, StoredProcedure.class, DatabasePackage.class};
    }

    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        CreatePackageBodyChange change = new CreatePackageBodyChange();
        if (diffOutputControl.getIncludeCatalog()) {
            change.setCatalogName(databaseObject.getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            change.setSchemaName(databaseObject.getSchema().getName());
        }
        change.setPackageBodyName(databaseObject.getName());
        change.setPackageBodyText(((StoredDatabaseLogic)databaseObject).getBody());
        return new Change[]{change};
    }
}

