/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.DropTriggerStatement;
import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.CreateProcedureGenerator;
import liquibase.structure.DatabaseObject;

public class DropTriggerGenerator
extends AbstractSqlGenerator<DropTriggerStatement> {
    public boolean supports(DropTriggerStatement statement, Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase);
    }

    public ValidationErrors validate(DropTriggerStatement dropTrigger, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkDisallowedField("catalogName", (Object)dropTrigger.getCatalogName(), database, new Class[]{MSSQLDatabase.class});
        validationErrors.checkRequiredField("triggerName", (Object)dropTrigger.getTriggerName());
        if (dropTrigger.getScope() != null) {
            if (database instanceof MSSQLDatabase && !dropTrigger.getScope().equalsIgnoreCase("CATALOG") && dropTrigger.getScope().equalsIgnoreCase("TABLE")) {
                validationErrors.addError("Invalid dropTrigger scope " + dropTrigger.getScope() + ". Possible values: CATALOG, TABLE");
            }
            if (database instanceof PostgresDatabase) {
                if (!dropTrigger.getScope().equalsIgnoreCase("CASCADE") && !dropTrigger.getScope().equalsIgnoreCase("RESTRICT")) {
                    validationErrors.addError("Invalid dropTrigger scope " + dropTrigger.getScope() + ". Possible values: CASCADE , RESTRICT ");
                }
                validationErrors.checkRequiredField("tableName", (Object)dropTrigger.getTableName());
            }
        }
        return validationErrors;
    }

    public Sql[] generateSql(DropTriggerStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String objectName;
        String endDelimiter = ";";
        ArrayList<UnparsedSql> returnSql = new ArrayList<UnparsedSql>();
        StringBuilder sql = new StringBuilder();
        String triggerName = database.escapeObjectName(statement.getCatalogName(), statement.getSchemaName(), statement.getTriggerName(), Trigger.class);
        sql.append("DROP TRIGGER ");
        if (database instanceof MSSQLDatabase && statement.getScope() != null && statement.getScope().equalsIgnoreCase("CATALOG")) {
            objectName = database.escapeObjectName(statement.getTriggerName(), Trigger.class);
            triggerName = String.format("%s ON DATABASE", objectName);
        }
        if (database instanceof PostgresDatabase) {
            String scope;
            objectName = database.escapeObjectName(statement.getTriggerName(), Trigger.class);
            String tableName = database.escapeObjectName(statement.getTableName(), Trigger.class);
            String schemaName = database.escapeObjectName(statement.getSchemaName(), Trigger.class);
            if (schemaName == null || schemaName.isEmpty()) {
                schemaName = database.getDefaultSchemaName();
            }
            if ((scope = database.escapeObjectName(statement.getScope(), Trigger.class)) == null) {
                scope = "";
            }
            triggerName = String.format("%s ON %s.%s %s", objectName, schemaName, tableName, scope);
        } else if (database instanceof MySQLDatabase) {
            // empty if block
        }
        sql.append(triggerName);
        returnSql.add(new UnparsedSql(sql.toString(), new DatabaseObject[0]));
        CreateProcedureGenerator.surroundWithSchemaSets(returnSql, (String)statement.getSchemaName(), (Database)database);
        return returnSql.toArray(new Sql[0]);
    }
}

