/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.basic.AbstractNotAllowedToContainRule;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class SqlNotAllowedToContainGrant
extends AbstractNotAllowedToContainRule {
    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public List<Pattern> getReservedPhrase() {
        return Arrays.asList(Pattern.compile("grant\\s"), Pattern.compile("grant\\["));
    }

    @Override
    public String getFailureMessage() {
        return "A statement granting privileges to a role or user was detected in your changelog. To prevent unintended access to the database or data it is recommended that the granting and revocation of privileges be carefully reviewed.";
    }

    @Override
    public String getName() {
        return "Warn on Detection of 'GRANT' Statements";
    }

    @Override
    public String getDescription() {
        return "This check warns a user when SQL contains 'GRANT' statements so that they can ensure that the privilege being granted won't lead to security issues.";
    }

    @Override
    public String getShortName() {
        return "SqlGrantWarn";
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }

    @Override
    public List<String> getSupportedChangesetFormats() {
        return AbstractLiquibaseRule.SupportedChangesetFormats.UNMODELED;
    }
}

