/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.FileAccessorDTO;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.resource.Resource;
import liquibase.util.StringUtil;

@Deprecated
public class FileEncoder {
    public static final String QUALITY_CHECKS_PREFIX = "Quality Checks Version:";
    private static final String LINE_SEPARATOR = "\n";
    @Deprecated
    private static final String SEPARATOR = "-----------------------------------------------------------------------------------------------";

    public static String generateFileHeader() {
        StringBuilder params = new StringBuilder();
        DynamicRuleParameterEnum[] values = DynamicRuleParameterEnum.values();
        Arrays.sort(values, Comparator.comparing(Enum::toString));
        for (DynamicRuleParameterEnum value : values) {
            params.append("##    ");
            params.append(value.toString());
            params.append(": <");
            if (StringUtil.isEmpty((String)value.options)) {
                params.append(value.interactiveCommandLineValueGetter.describe());
            } else {
                params.append(value.options);
            }
            params.append(">");
            params.append(LINE_SEPARATOR);
        }
        String header = "## Policy Checks Settings File\n########## IMPORTANT: NEVER EDIT THIS KEY\n## id: 'some-l0ng-uni4ue-id3nt1fier-c0d3'\n\n########## ALWAYS EDITABLE KEY VALUES and PARAMETERS\n##  severity: <can be set to " + StringUtil.join((Collection)Arrays.stream(SeverityEnum.values()).map(SeverityEnum::getExitValue).sorted().collect(Collectors.toList()), (String)", ", Object::toString) + ">" + LINE_SEPARATOR + "##  enabled: <can be \"true\" or \"false\">" + LINE_SEPARATOR + LINE_SEPARATOR + "########## EDITABLE PARAMETERS" + LINE_SEPARATOR + "##  Standard value options:" + LINE_SEPARATOR + params;
        return header + LINE_SEPARATOR;
    }

    public static FileAccessorDTO decode(String contents, Resource resource) {
        String loadedContents;
        FileAccessorDTO dto = new FileAccessorDTO();
        dto.setOriginalContents(contents);
        if (!FileEncoder.isVersioned(contents)) {
            Scope.getCurrentScope().getLog(FileEncoder.class).info("The contents of this settings file are not versioned");
        } else {
            dto.versioned = true;
        }
        try {
            loadedContents = new String(Base64.getDecoder().decode(FileEncoder.stripHeaderFromString(contents)));
            dto.encoded = true;
        }
        catch (Exception e) {
            loadedContents = FileEncoder.stripHeaderFromString(contents);
            dto.encoded = false;
        }
        dto.contents = loadedContents;
        dto.resource = resource;
        return dto;
    }

    private static String stripHeaderFromString(String contents) {
        int separatorIndex = contents.indexOf(SEPARATOR);
        if (separatorIndex == -1) {
            return contents;
        }
        String lineWithoutDashes = contents.substring(separatorIndex + SEPARATOR.length());
        if (lineWithoutDashes.startsWith(LINE_SEPARATOR)) {
            return lineWithoutDashes.replaceFirst(LINE_SEPARATOR, "");
        }
        if (lineWithoutDashes.startsWith("\r\n")) {
            return lineWithoutDashes.replaceFirst("\r\n", "");
        }
        return lineWithoutDashes;
    }

    private static boolean isVersioned(String contents) {
        return contents.contains(QUALITY_CHECKS_PREFIX);
    }
}

