/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.Constraint;
import com.datical.liquibase.ext.checks.config.ConstraintOperatorEnum;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RegexGetter;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.cli.StringEnumListGetter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import com.datical.liquibase.ext.util.DatabaseObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import liquibase.changelog.ChangeSet;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;
import liquibase.util.StringUtil;

public class ConstraintMustExist
extends AbstractLiquibaseDynamicForecastRule {
    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.DATABASE);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    private List<Constraint> getConstraintParam(DynamicRule dynamicRule) {
        return StringEnumListGetter.split((String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.CONSTRAINT), Constraint.class, true);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        if (!(databaseObject instanceof Table)) {
            this.addNonApplicableRuleIteration(databaseObject, String.format("Object '%s' not applicable for rule '%s'", databaseObject.getName(), dynamicRule.getShortName()), RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE, (AbstractConfigurableRule)dynamicRule);
            return true;
        }
        String tableName = databaseObject.getName();
        String desiredTableName = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.TABLE_NAME);
        ConstraintOperatorEnum operator = dynamicRule.getEnumParameterValue(DynamicRuleParameterEnum.CONSTRAINT_OPERATOR, ConstraintOperatorEnum.class);
        String desiredColumnName = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.COLUMN_NAME);
        Boolean caseSensitive = (Boolean)DynamicRuleParameterEnum.CASE_SENSITIVE.defaultValue;
        try {
            caseSensitive = this.getCaseSensitiveParam(dynamicRule, operator);
        }
        catch (Exception e) {
            this.putResultUnsuccessful(databaseObject, "Rule is using a " + (Object)((Object)ConstraintOperatorEnum.REGEXP) + " operator, but also has a value for the " + (Object)((Object)DynamicRuleParameterEnum.CASE_SENSITIVE) + " param.", (AbstractConfigurableRule)dynamicRule);
        }
        if (StringUtil.isEmpty((String)desiredTableName) || operator.matches(desiredTableName, tableName, caseSensitive)) {
            List<Constraint> constraints = this.getConstraintParam(dynamicRule);
            boolean allPass = true;
            for (Constraint constraint : constraints) {
                Set<String> columnNames = constraint.getColumnNames((Table)databaseObject);
                boolean matchingColumnFound = false;
                if (columnNames != null) {
                    if (desiredColumnName != null) {
                        String[] desiredParts;
                        block3: for (String desiredColumn : desiredParts = desiredColumnName.split(",")) {
                            for (String columnName : columnNames) {
                                if (!operator.matches(desiredColumn, columnName, caseSensitive)) continue;
                                matchingColumnFound = true;
                                continue block3;
                            }
                        }
                    } else {
                        for (String columnName : columnNames) {
                            if (!operator.matches(null, columnName, caseSensitive)) continue;
                            matchingColumnFound = true;
                            break;
                        }
                    }
                }
                if (matchingColumnFound) continue;
                this.addFailureRuleIteration(databaseObject, this.getFailureMessage((String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.MESSAGE), DatabaseObjectUtils.buildFullyQualifiedName(databaseObject), constraint), (AbstractConfigurableRule)dynamicRule);
                allPass = false;
            }
            if (allPass) {
                this.putResultSuccessful(databaseObject, true, (AbstractConfigurableRule)dynamicRule);
            }
        }
        return true;
    }

    private String getFailureMessage(String messageTemplate, String tableName, Constraint constraint) {
        return messageTemplate.replace("<" + (Object)((Object)DynamicRuleParameterEnum.TABLE_NAME) + ">", tableName).replace("<" + (Object)((Object)DynamicRuleParameterEnum.CONSTRAINT) + ">", constraint.toString());
    }

    private Boolean getCaseSensitiveParam(DynamicRule dynamicRule, ConstraintOperatorEnum operator) throws Exception {
        Boolean caseSensitive = (Boolean)DynamicRuleParameterEnum.CASE_SENSITIVE.defaultValue;
        if (operator != ConstraintOperatorEnum.REGEXP) {
            caseSensitive = (Boolean)dynamicRule.getParameterValue(DynamicRuleParameterEnum.CASE_SENSITIVE);
        } else if (dynamicRule.getParameter(DynamicRuleParameterEnum.CASE_SENSITIVE) != null) {
            throw new Exception("Rule is using a " + (Object)((Object)ConstraintOperatorEnum.REGEXP) + " operator, but also has a value for the " + (Object)((Object)DynamicRuleParameterEnum.CASE_SENSITIVE) + " param.");
        }
        return caseSensitive;
    }

    @Override
    public String getDescription() {
        return "Check for and alert when specified table does not contain the required constraint(s).";
    }

    @Override
    public String getShortName() {
        return "ConstraintMustExist";
    }

    @Override
    public int getPriority() {
        return 570;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.CONSTRAINT_OPERATOR), new RuleParameter<String>(DynamicRuleParameterEnum.TABLE_NAME, ConstraintMustExist::validateSearchString, ConstraintMustExist::shouldPromptForNames, null, true), new RuleParameter<String>(DynamicRuleParameterEnum.COLUMN_NAME, ConstraintMustExist::validateSearchString, ConstraintMustExist::shouldPromptForNames), new RuleParameter(DynamicRuleParameterEnum.CONSTRAINT), new RuleParameter(DynamicRuleParameterEnum.CASE_SENSITIVE, null, newParameterValues -> {
            Optional<DynamicRuleParameter> operatorParamOpt = newParameterValues.stream().filter(pv -> pv.getParameterAsEnum() == DynamicRuleParameterEnum.CONSTRAINT_OPERATOR).findFirst();
            DynamicRuleParameter operatorParam = operatorParamOpt.get();
            Object operator = operatorParam.getValue() instanceof String ? ConstraintOperatorEnum.valueOf((String)operatorParam.getValue()) : operatorParam.getValue();
            return operator != ConstraintOperatorEnum.REGEXP;
        }), new RuleParameter(DynamicRuleParameterEnum.MESSAGE, null, null, "The specified table '<" + (Object)((Object)DynamicRuleParameterEnum.TABLE_NAME) + ">' does not contain the required '<" + (Object)((Object)DynamicRuleParameterEnum.CONSTRAINT) + ">' constraint.", false));
    }

    private static Boolean shouldPromptForNames(List<DynamicRuleParameter> newParameterValues) {
        Optional<DynamicRuleParameter> operatorParamOpt = newParameterValues.stream().filter(pv -> pv.getParameterAsEnum() == DynamicRuleParameterEnum.CONSTRAINT_OPERATOR).findFirst();
        if (!operatorParamOpt.isPresent()) {
            return true;
        }
        DynamicRuleParameter operatorParam = operatorParamOpt.get();
        Object operator = operatorParam.getValue() instanceof String ? ConstraintOperatorEnum.valueOf((String)operatorParam.getValue()) : operatorParam.getValue();
        return operator != ConstraintOperatorEnum.ALL;
    }

    private static Boolean validateSearchString(String value, List<DynamicRuleParameter> newParameterValues) {
        Optional<DynamicRuleParameter> operatorParamOpt = newParameterValues.stream().filter(pv -> pv.getParameterAsEnum() == DynamicRuleParameterEnum.CONSTRAINT_OPERATOR).findFirst();
        if (!operatorParamOpt.isPresent()) {
            return true;
        }
        DynamicRuleParameter operatorParam = operatorParamOpt.get();
        if (operatorParam.getValue() == ConstraintOperatorEnum.REGEXP) {
            if (StringUtil.isNotEmpty((String)value)) {
                return new RegexGetter().validate(value);
            }
            return true;
        }
        return true;
    }
}

