/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.checks.config.model.MatcherContext;
import com.datical.liquibase.ext.checks.dynamic.CheckForSpecificPatternsInSQL;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.structure.DatabaseObject;
import org.apache.commons.lang3.StringUtils;

public class EndDelimiterExistsWhenPatternExists
extends AbstractLiquibaseDynamicForecastRule {
    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, Database database, DynamicRule dynamicRule) {
        DynamicRuleParameter searchStringParam = dynamicRule.getParameter(DynamicRuleParameterEnum.SEARCH_STRING);
        DynamicRuleParameter messageParam = dynamicRule.getParameter(DynamicRuleParameterEnum.MESSAGE);
        DynamicRuleParameter stripCommentsParam = dynamicRule.getParameter(DynamicRuleParameterEnum.STRIP_COMMENTS);
        DynamicRuleParameter caseSensitiveParam = dynamicRule.getParameter(DynamicRuleParameterEnum.CASE_SENSITIVE);
        Objects.requireNonNull(searchStringParam);
        Objects.requireNonNull(messageParam);
        Objects.requireNonNull(stripCommentsParam);
        Objects.requireNonNull(caseSensitiveParam);
        int flags = 0;
        if (!((Boolean)caseSensitiveParam.getValue()).booleanValue()) {
            flags = 2;
        }
        String searchStringParamValue = searchStringParam.getValue().toString();
        Pattern searchString = Pattern.compile(searchStringParamValue, flags);
        String messageTemplate = (String)messageParam.getValue();
        Boolean stripComments = (Boolean)stripCommentsParam.getValue();
        for (Change change : changeSet.getChanges()) {
            try {
                if (!(change instanceof AbstractSQLChange)) continue;
                MatcherContext matcherContext = CheckForSpecificPatternsInSQL.doCheck(change, database, searchString, stripComments, null, false);
                if (!matcherContext.matchResult || !StringUtils.isEmpty((CharSequence)((AbstractSQLChange)change).getEndDelimiter())) continue;
                this.addFailureRuleIteration(changeSet, change, this.getFailureMessage(messageTemplate, searchStringParamValue, changeSet), (AbstractConfigurableRule)dynamicRule, false);
            }
            catch (IllegalStateException ise) {
                Scope.getCurrentScope().getLog(CheckForSpecificPatternsInSQL.class).info("Error generating SQL for change '" + change.getDescription() + "': " + ise.getMessage());
                this.addFailureRuleIteration(changeSet, change, "Unable to generate SQL for change '" + change.getDescription() + "'. Checks executed against the H2 database for this object type are not available.", (AbstractConfigurableRule)dynamicRule);
            }
        }
        return this.returnAtEndOfRule(changeSet, (AbstractConfigurableRule)dynamicRule);
    }

    private String getFailureMessage(String messageTemplate, String searchString, ChangeSet changeSet) {
        return messageTemplate.replace("<" + (Object)((Object)DynamicRuleParameterEnum.SEARCH_STRING) + ">", searchString).replace("<CHANGESET>", changeSet.toString());
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDescription() {
        return "This check triggers when a changeset contains the supplied pattern string or regex, but does not have an end delimiter set specifically in the changeset or via options such as 'pro-global-end-delimiter' or 'endDelimiter' attribute in a modifyChangesets tag.";
    }

    @Override
    public String getShortName() {
        return "EndDelimiterExistsWhenPatternExists";
    }

    @Override
    public int getPriority() {
        return 65;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.SEARCH_STRING), new RuleParameter(DynamicRuleParameterEnum.CASE_SENSITIVE), new RuleParameter(DynamicRuleParameterEnum.STRIP_COMMENTS), new RuleParameter(DynamicRuleParameterEnum.MESSAGE, null, null, "The pattern '<" + (Object)((Object)DynamicRuleParameterEnum.SEARCH_STRING) + ">' was found without an end delimiter in Changeset '<CHANGESET>'.", false));
    }
}

