/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.JSqlParserCache;
import com.datical.liquibase.ext.checks.SqlParseException;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.CreateTableChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statements;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.CreateTable;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class TableColumnCountWarning
extends AbstractLiquibaseDynamicForecastRule {
    @Override
    public String getName() {
        return "Check Table Column Count";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Arrays.asList(ScopeEnum.CHANGELOG, ScopeEnum.DATABASE);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getShortName() {
        return "TableColumnLimit";
    }

    private boolean doEvaluate(List<Change> changes, ChangeSet changeSet, DynamicRule dynamicRule, boolean isRollback) {
        boolean applicable = false;
        for (Change change : changes) {
            Integer threshold = (Integer)dynamicRule.getParameters().get(0).getValue();
            if (change instanceof CreateTableChange) {
                applicable = true;
                if (!this.doTableColumnCountCheck((CreateTableChange)change, (int)threshold)) continue;
                this.addErrorMessage(changeSet, change, threshold, dynamicRule, isRollback);
                continue;
            }
            if (!(change instanceof AbstractSQLChange)) continue;
            try {
                Statements statements = JSqlParserCache.parseSql(TableColumnCountWarning.getSql((AbstractSQLChange)change), true);
                for (Statement statement : statements.getStatements()) {
                    if (!(statement instanceof CreateTable)) continue;
                    applicable = true;
                    if (!this.doTableColumnCountCheck((CreateTable)statement, (int)threshold)) continue;
                    this.addErrorMessage(changeSet, change, threshold, dynamicRule, isRollback);
                }
            }
            catch (SqlParseException e) {
                Level level = (Level)Scope.getCurrentScope().get(ChecksRunCommandStep.SQL_PARSE_EXCEPTION_LOG_AT_LEVEL_ARG.getName(), (Object)Level.FINE);
                Scope.getCurrentScope().getLog(this.getClass()).log(level, "Failed to parse SQL", (Throwable)e);
                this.addFailureRuleIteration(changeSet, change, "Some or all of the SQL could not be parsed by this check. Please review the changeset or SQL directly to make sure it is valid.", RuleIteration.FailureReason.SQL_PARSING, dynamicRule, isRollback);
            }
        }
        if (!applicable) {
            this.addNonApplicableRuleIteration(changeSet, String.format("Changeset '%s' not applicable for rule '%s'", changeSet.toString(), dynamicRule.getShortName()), RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE, (AbstractConfigurableRule)dynamicRule);
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, isRollback);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule instance) {
        return this.doEvaluate(changeSet.getChanges(), changeSet, instance, false);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, Database database, DynamicRule dr) {
        return this.doEvaluate(changes, changeSet, dr, true);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        Integer threshold = (Integer)dynamicRule.getParameters().get(0).getValue();
        if (databaseObject instanceof Table) {
            if (this.doTableColumnCountCheck((Table)databaseObject, (int)threshold)) {
                this.addErrorMessage(databaseObject, threshold, dynamicRule);
            }
        } else {
            this.addNonApplicableRuleIteration(databaseObject, String.format("Object '%s' not applicable for rule '%s'", databaseObject.getName(), dynamicRule.getShortName()), RuleIteration.FailureReason.OBJECT_TYPE_NOT_APPLICABLE, (AbstractConfigurableRule)dynamicRule);
        }
        return this.returnAtEndOfRule(databaseObject, (AbstractConfigurableRule)dynamicRule);
    }

    private void addErrorMessage(ChangeSet changeSet, Change change, Integer threshold, DynamicRule instance, boolean isRollback) {
        String plurality = this.determinePlurality(threshold);
        this.addFailureRuleIteration(changeSet, change, String.format("Table must not have more than %d %s.", threshold, plurality), (AbstractConfigurableRule)instance, isRollback);
    }

    private void addErrorMessage(DatabaseObject databaseObject, Integer threshold, DynamicRule instance) {
        String plurality = this.determinePlurality(threshold);
        this.addFailureRuleIteration(databaseObject, String.format("Table %s must not have more than %d %s.", databaseObject.getName(), threshold, plurality), (AbstractConfigurableRule)instance);
    }

    private String determinePlurality(Integer threshold) {
        if (threshold == 1) {
            return "column";
        }
        return "columns";
    }

    private boolean doTableColumnCountCheck(CreateTableChange change, int threshold) {
        return change.getColumns().size() > threshold;
    }

    private boolean doTableColumnCountCheck(Table table, int threshold) {
        return table.getColumns().size() > threshold;
    }

    private boolean doTableColumnCountCheck(CreateTable change, int threshold) {
        return change.getColumnDefinitions().size() > threshold;
    }

    @Override
    public String getDescription() {
        return "Ensures that no table has more than a threshold number of columns.";
    }

    @Override
    public int getPriority() {
        return 70;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Collections.singletonList(new RuleParameter(DynamicRuleParameterEnum.MAX_COLUMNS));
    }
}

