/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.cli.StringListGetter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.logging.custommdc.Cache;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.change.ChangeFactory;
import liquibase.changelog.ChangeSet;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.structure.DatabaseObject;

public class WarnOnSpecificChangeTypes
extends AbstractLiquibaseDynamicForecastRule {
    public static final Cache<Set<String>> REGISTERED_CHANGE_NAMES = new Cache<Set>(() -> ((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getDefinedChanges().stream().map(String::toUpperCase).collect(Collectors.toSet()));

    @Override
    public String getName() {
        return "Warn on Use of User Defined ChangeTypes";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        String forbiddenChangesParameter = (String)dynamicRule.getParameter(DynamicRuleParameterEnum.CHANGE_TYPE_LIST).getValue();
        List<String> forbiddenChangesList = StringListGetter.split(forbiddenChangesParameter);
        Set<String> usedChangesList = this.getChangeSetChanges(changeSet);
        for (String changeName : forbiddenChangesList) {
            if (!usedChangesList.stream().anyMatch(changeName::equalsIgnoreCase)) continue;
            String failMessage = String.format("A ChangeSet includes a '%s' change. This ChangeType has been flagged for review in your checks configuration. Review this ChangeSet to confirm that use of this ChangeType is acceptable.", changeName);
            this.addFailureRuleIteration(changeSet, failMessage, (AbstractConfigurableRule)dynamicRule);
        }
        return this.returnAtEndOfRule(changeSet, (AbstractConfigurableRule)dynamicRule);
    }

    private Set<String> getChangeSetChanges(ChangeSet changeSet) {
        return changeSet.getChanges().stream().map(LiquibaseSerializable::getSerializedObjectName).collect(Collectors.toSet());
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Collections.singletonList(new RuleParameter(DynamicRuleParameterEnum.CHANGE_TYPE_LIST));
    }

    @Override
    public String getDescription() {
        return "This check warns a user when a ChangeSet includes a ChangeType listed by the user as forbidden";
    }

    @Override
    public String getShortName() {
        return "DetectChangeType";
    }

    @Override
    public int getPriority() {
        return 150;
    }

    @Override
    public List<String> getSupportedChangesetFormats() {
        return AbstractLiquibaseRule.SupportedChangesetFormats.MODELED;
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }
}

