/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksCopyCommandStep;
import com.datical.liquibase.ext.command.helpers.ChecksAutoEnableNewChecksArgument;
import com.datical.liquibase.ext.command.helpers.ChecksAutoUpdateArgument;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.LiquibaseException;
import liquibase.license.pro.LicenseTier;

public class ChecksCustomizeCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "customize"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(ChecksAutoUpdateArgument.class, ChecksAutoEnableNewChecksArgument.class);
    }

    public final void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String checksSettingsFile = (String)commandScope.getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        String checkName = (String)commandScope.getConfiguredValue(CHECK_NAME_ARG).getValue();
        List<AbstractLiquibaseRule> rules = ChecksCustomizeCommandStep.listAllRules();
        Boolean autoUpdate = (Boolean)commandScope.getDependency(ChecksAutoUpdateArgument.class);
        Boolean autoEnableNewChecks = (Boolean)commandScope.getDependency(ChecksAutoEnableNewChecksArgument.class);
        CheckSettingsConfigHelper helper = new CheckSettingsConfigHelper(checksSettingsFile, autoUpdate, autoEnableNewChecks);
        CheckSettingsConfig csc = helper.read(rules);
        this.throwExceptionIfPackageFile(csc);
        if (csc == null) {
            resultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        Optional<AbstractLiquibaseRule> optRule = rules.stream().filter(r -> r.getShortName().equalsIgnoreCase(checkName)).findFirst();
        if (optRule.isPresent()) {
            AbstractLiquibaseRule abstractLiquibaseRule = optRule.get();
            this.checkMinimumRequiredLicense(abstractLiquibaseRule.getMinimumAllowableLicense());
        }
        if (optRule.isPresent() && !optRule.get().isConfigurable()) {
            AbstractLiquibaseRule rule = optRule.get();
            AbstractConfigurableRule ruleToModify = csc.getRuleById(rule.getId());
            if (ruleToModify == null) {
                throw new CommandExecutionException("Unable to locate check to modify '" + rule.getShortName() + "' in configuration settings.");
            }
            if (ChecksCustomizeCommandStep.modifySeverity(ruleToModify)) {
                helper.write(csc);
            }
            Scope.getCurrentScope().getUI().sendMessage("Customization complete. Review the table below to confirm your changes.");
            ChecksCustomizeCommandStep.showFilteredTable(resultsBuilder, Collections.singletonList(checkName), csc);
            resultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        DynamicRule configurableRule = csc.getDynamicConfigurableRuleByShortName(checkName, "does not have customization options");
        AbstractLiquibaseRule parentRule = ChecksCustomizeCommandStep.findConfigurableParentRule(configurableRule, rules, checkName, "does not have customization options");
        if (!parentRule.hasDefaultParameterValues() && !configurableRule.isCopy()) {
            Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "This check can not be customized directly because one or more fields does not have a default value.  Creating a copy of this check and initiating the customization workflow.");
            ChecksCopyCommandStep.doCopy(csc, checkName, rules, resultsBuilder, helper, true);
        } else {
            String shouldEnable;
            this.checkMinimumRequiredLicense(parentRule.getMinimumAllowableLicense());
            ChecksCustomizeCommandStep.modifySeverity(configurableRule);
            ArrayList newParameterValues = new ArrayList();
            try {
                Scope.child((String)"checkSettingsConfig", (Object)csc, () -> newParameterValues.addAll(ChecksCustomizeCommandStep.promptForParameters(parentRule.getParameters(), configurableRule)));
            }
            catch (Exception e) {
                throw new LiquibaseException((Throwable)e);
            }
            if (!configurableRule.isEnabled() && (shouldEnable = (String)Scope.getCurrentScope().getUI().prompt("This check is disabled.  Enable it? (Y/n)", null, (input, type) -> {
                if (input == null || !input.equalsIgnoreCase("y") && !input.equalsIgnoreCase("n")) {
                    throw new IllegalArgumentException();
                }
                return input;
            }, String.class)) != null && shouldEnable.equalsIgnoreCase("y")) {
                configurableRule.setEnabled(true);
            }
            configurableRule.getParameters().clear();
            configurableRule.getParameters().addAll(newParameterValues);
            helper.write(csc);
            Scope.getCurrentScope().getUI().sendMessage("Customization complete. Review the table below to confirm your changes.");
            ChecksCustomizeCommandStep.showFilteredTable(resultsBuilder, Arrays.asList(checkName, configurableRule.getShortName()), csc);
        }
        csc.outputWarningMessage();
        resultsBuilder.addResult("statusCode", (Object)0);
    }

    private void checkMinimumRequiredLicense(LicenseTier minimumAllowableLicense) throws CommandExecutionException {
        if (!minimumAllowableLicense.isValid()) {
            String msg = "To copy or customize " + minimumAllowableLicense.getSubject() + "-licensed checks requires a valid " + minimumAllowableLicense.getSubject() + " license key in liquibase.licenseKey property. To get a trial " + minimumAllowableLicense.getSubject() + " license visit " + "https://liquibase.com/trial";
            throw new CommandExecutionException(msg);
        }
    }

    public static List<DynamicRuleParameter> promptForParameters(List<RuleParameter<?>> parameters, DynamicRule configurableRule) throws Exception {
        ArrayList<DynamicRuleParameter> newParameterValues = new ArrayList<DynamicRuleParameter>(parameters.size());
        for (RuleParameter<?> parameter : parameters) {
            if (!parameter.shouldPrompt(newParameterValues)) continue;
            Optional<DynamicRuleParameter> existingValueParamOpt = configurableRule.getParameters().stream().filter(p -> p.getParameterAsEnum() == parameter.getParameter()).findFirst();
            Object currentValue = !existingValueParamOpt.isPresent() ? null : existingValueParamOpt.get().getValue();
            Object newValue = parameter.getInteractiveCommandLineValueGetter().prompt(parameter, newParameterValues, currentValue);
            DynamicRuleParameter drp = new DynamicRuleParameter(parameter.getParameter(), newValue);
            newParameterValues.add(drp);
        }
        return newParameterValues;
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("CLI-guided configuration of the named check");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Policy Checks commands");
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = builder.argument("checkName", String.class).required().description("Name of check to configure").build();
        CHECKS_SETTINGS_FILE_ARG = builder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
    }
}

