/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.core.LiquibaseQualityCheckResult;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.RuleCombination;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.resource.Resource;
import lombok.Generated;

public class EngineResults<T> {
    private final List<RuleCombination> skippedBecauseOfLicenceRules;
    private final Map<AbstractConfigurableRule, List<AbstractConfigurableRule>> skippedBecauseOfScope;
    private final LinkedHashMap<T, LiquibaseQualityCheckResult> results;
    private final List<Resource> resources;
    private final List<LiquibaseRuleResult> skippedMissingScriptChecks;
    private final List<LiquibaseRuleResult> skippedDisabledCustomChecks;

    public EngineResults(List<Resource> resources) {
        this(Collections.emptyList(), Collections.emptyMap(), new LinkedHashMap(), resources);
    }

    public EngineResults(List<RuleCombination> skippedBecauseOfLicenceRules, Map<AbstractConfigurableRule, List<AbstractConfigurableRule>> skippedBecauseOfScope, LinkedHashMap<T, LiquibaseQualityCheckResult> results, List<Resource> resources) {
        this.skippedBecauseOfLicenceRules = skippedBecauseOfLicenceRules;
        this.skippedBecauseOfScope = skippedBecauseOfScope;
        this.results = results;
        this.resources = resources;
        this.skippedMissingScriptChecks = new ArrayList<LiquibaseRuleResult>();
        this.skippedDisabledCustomChecks = new ArrayList<LiquibaseRuleResult>();
    }

    public Map<AbstractConfigurableRule, List<AbstractConfigurableRule>> getSkippedBecauseOfScope() {
        return this.skippedBecauseOfScope;
    }

    public List<RuleCombination> getSkippedBecauseOfLicenceRules(String checkSettingsConfigFilename) {
        return this.skippedBecauseOfLicenceRules.stream().filter(rc -> {
            AbstractConfigurableRule configurableRule = rc.configurableRule;
            return configurableRule.checkSettingsConfigFilenameMatches(checkSettingsConfigFilename);
        }).collect(Collectors.toList());
    }

    public void addResults(EngineResults<T> mergeFrom) {
        LinkedHashMap<T, LiquibaseQualityCheckResult> mergeFromResults = mergeFrom.getResults();
        for (Map.Entry<T, LiquibaseQualityCheckResult> entry2 : mergeFromResults.entrySet()) {
            LiquibaseQualityCheckResult mergeToResult = this.getResults().get(entry2.getKey());
            if (mergeToResult == null) continue;
            List<LiquibaseRuleResult> resultsToAdd = entry2.getValue().getRuleResults();
            mergeToResult.addResults(resultsToAdd);
            mergeToResult.addExecutedRules(entry2.getValue().getExecutedRules());
        }
        this.getSkippedBecauseOfScope().keySet().removeIf(entry -> !(entry instanceof DynamicRule) || !((DynamicRule)entry).isChained());
        for (Map.Entry<Object, Object> entry3 : mergeFrom.getSkippedBecauseOfScope().entrySet()) {
            if (!(entry3.getKey() instanceof DynamicRule) || !((DynamicRule)entry3.getKey()).isChained()) continue;
            this.getSkippedBecauseOfScope().put((AbstractConfigurableRule)entry3.getKey(), (List<AbstractConfigurableRule>)entry3.getValue());
        }
    }

    public LinkedHashSet<String> getAllChecksSettingsConfigFilenames() {
        if (this.resources == null) {
            ArrayList tempResources = new ArrayList();
            return tempResources.stream().map(Resource::getPath).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return this.resources.stream().map(Resource::getPath).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<RuleCombination> getExecutedRules() {
        LinkedHashSet<RuleCombination> executedRuleNames = new LinkedHashSet<RuleCombination>();
        this.getResults().forEach((changeSet, changeSetCheckResult) -> executedRuleNames.addAll(changeSetCheckResult.getExecutedRules()));
        return executedRuleNames;
    }

    public Set<RuleCombination> getExecutedRules(String checkSettingsConfigFilename) {
        LinkedHashSet<RuleCombination> executedRuleNames = new LinkedHashSet<RuleCombination>();
        this.getResults().forEach((changeSet, changeSetCheckResult) -> executedRuleNames.addAll(changeSetCheckResult.getExecutedRules(checkSettingsConfigFilename)));
        return executedRuleNames;
    }

    @Generated
    public List<RuleCombination> getSkippedBecauseOfLicenceRules() {
        return this.skippedBecauseOfLicenceRules;
    }

    @Generated
    public LinkedHashMap<T, LiquibaseQualityCheckResult> getResults() {
        return this.results;
    }

    @Generated
    public List<LiquibaseRuleResult> getSkippedMissingScriptChecks() {
        return this.skippedMissingScriptChecks;
    }

    @Generated
    public List<LiquibaseRuleResult> getSkippedDisabledCustomChecks() {
        return this.skippedDisabledCustomChecks;
    }
}

