/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage.change;

import com.datical.liquibase.ext.storedlogic.databasepackage.change.CreatePackageBodyStatement;
import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.CreateProcedureGenerator;
import liquibase.structure.DatabaseObject;

public class CreatePackageBodyGenerator
extends AbstractSqlGenerator<CreatePackageBodyStatement> {
    public int getPriority() {
        return 6;
    }

    public ValidationErrors validate(CreatePackageBodyStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("packageBodyName", (Object)statement.getPackageBodyName());
        validationErrors.checkRequiredField("packageBodyText", (Object)statement.getPackageBodyText());
        return validationErrors;
    }

    public Sql[] generateSql(CreatePackageBodyStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String endDelimiter = ";";
        if (database instanceof OracleDatabase || database instanceof EnterpriseDBDatabase) {
            endDelimiter = "\n/";
        } else if (database instanceof DB2Database) {
            endDelimiter = "";
        }
        ArrayList<UnparsedSql> sql = new ArrayList<UnparsedSql>();
        sql.add(new UnparsedSql(CreateProcedureGenerator.addSchemaToText((String)CreateProcedureGenerator.removeTrailingDelimiter((String)statement.getPackageBodyText(), (String)endDelimiter), (String)statement.getSchemaName(), (String)"BODY", (Database)database), endDelimiter, new DatabaseObject[0]));
        CreateProcedureGenerator.surroundWithSchemaSets(sql, (String)statement.getSchemaName(), (Database)database);
        return sql.toArray(new Sql[sql.size()]);
    }
}

