/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.function.change.CreateFunctionStatement;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.ChecksumVersion;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SnowflakeDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.license.pro.LicenseTier;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createFunction", description="Creates a stored function", priority=101, appliesTo={"function"})
public class CreateFunctionChange
extends CreateProcedureChange {
    private String functionName;
    private String functionBody;
    private boolean useChecksumV8ForLiquibase421x = false;

    public boolean supports(Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase || database instanceof SnowflakeDatabase;
    }

    public ValidationErrors validate(Database database) {
        if (this.supports(database)) {
            ValidationErrors validationErrors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
            if (validationErrors.hasErrors()) {
                return validationErrors;
            }
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, (Change)this);
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureName() {
        return this.getFunctionName();
    }

    public void setProcedureName(String procedureName) {
        this.setFunctionName(procedureName);
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureText() {
        return this.getFunctionBody();
    }

    public void setProcedureText(String procedureText) {
        this.setFunctionBody(procedureText);
    }

    @DatabaseChangeProperty(mustEqualExisting="function", description="Name of the function to create")
    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE, description="The SQL creating the function body. You need to define either this attribute or 'path'. functionBody is not supported in the XML format; however, you can specify the function body SQL inline within the createFunction definition.")
    public String getFunctionBody() {
        return this.functionBody;
    }

    public void setFunctionBody(String functionBody) {
        this.functionBody = functionBody;
    }

    public String getConfirmationMessage() {
        return "Function " + this.getFunctionName() + " created";
    }

    protected SqlStatement[] generateStatements(String logicText, String endDelimiter, Database database) {
        CreateFunctionStatement statement = new CreateFunctionStatement(this.getCatalogName(), this.getSchemaName(), this.getFunctionName(), logicText, endDelimiter);
        statement.setReplaceIfExists(this.getReplaceIfExists());
        return new SqlStatement[]{statement};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    public CheckSum generateCheckSum() {
        if (Scope.getCurrentScope().getChecksumVersion().lowerOrEqualThan(ChecksumVersion.V8)) {
            super.setProcedureText(this.useChecksumV8ForLiquibase421x ? null : this.getFunctionBody());
            return super.generateCheckSum();
        }
        return super.generateCheckSumLatest(this.functionBody);
    }

    public void setUseChecksumV8ForLiquibase421x(boolean useChecksumV8ForLiquibase421x) {
        this.useChecksumV8ForLiquibase421x = useChecksumV8ForLiquibase421x;
    }
}

