/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.AbstractMap;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.truelicense.core.util.Objects;

@Immutable
public class CacheEntry<K, V>
extends AbstractMap.SimpleEntry<K, V> {
    private static final long serialVersionUID = 1L;
    private final long cachePeriodMillis;
    private transient long startTimeMillis = System.currentTimeMillis();

    public CacheEntry(@CheckForNull K k, @CheckForNull V v) {
        this(k, v, Long.MAX_VALUE);
    }

    public CacheEntry(@CheckForNull K k, @CheckForNull V v, long l) {
        super(k, v);
        this.cachePeriodMillis = l;
        if (0L > this.cachePeriodMillis) {
            throw new IllegalArgumentException();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.startTimeMillis = System.currentTimeMillis();
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public long getCachePeriodMillis() {
        return this.cachePeriodMillis;
    }

    @CheckForNull
    public V map(@CheckForNull K k) {
        return this.matches(k) ? (V)this.getValue() : null;
    }

    public boolean matches(@CheckForNull K k) {
        return Objects.equals(k, this.getKey()) && !this.isObsolete();
    }

    public boolean isObsolete() {
        return System.currentTimeMillis() - this.getStartTimeMillis() >= this.getCachePeriodMillis();
    }
}

