/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog.filter;

import java.util.List;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.exception.LiquibaseException;
import liquibase.logging.Logger;

public class SingleRanChangeSetFilter
implements ChangeSetFilter {
    private String id;
    private String author;
    private String filePath;
    private RanChangeSet matchingIdChangeSet = null;
    private ChangeSet changeSet;

    public SingleRanChangeSetFilter(String id, String author, String filePath, List<RanChangeSet> ranChangeSets, DatabaseChangeLog changelog) throws LiquibaseException {
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        for (RanChangeSet ranChangeSet : ranChangeSets) {
            if (id.equalsIgnoreCase(ranChangeSet.getId()) && author.equalsIgnoreCase(ranChangeSet.getAuthor()) && filePath.equalsIgnoreCase(ranChangeSet.getChangeLog())) {
                this.changeSet = changelog.getChangeSet(filePath, author, id);
                if (this.changeSet == null) {
                    log.warning("Unable to locate the change for " + id + "::" + author + "::" + filePath);
                    String message = this.createNotFoundErrorMessage(changelog, id, author, filePath);
                    throw new LiquibaseException(message);
                }
                log.fine("FOUND the change for " + id + "::" + author + "::" + filePath);
                this.id = id;
                this.author = author;
                this.filePath = filePath;
                break;
            }
            if (id.equalsIgnoreCase(ranChangeSet.getId())) {
                this.matchingIdChangeSet = ranChangeSet;
            } else {
                log.fine("ID '" + id + "' did not match '" + ranChangeSet.getId() + "'");
            }
            if (!author.equalsIgnoreCase(ranChangeSet.getAuthor())) {
                log.fine("Author '" + author + "' did not match '" + ranChangeSet.getAuthor() + "'");
                continue;
            }
            if (filePath.equalsIgnoreCase(ranChangeSet.getChangeLog())) continue;
            log.fine("Path '" + filePath + "' did not match '" + ranChangeSet.getChangeLog() + "'");
            log.fine("Path length: " + filePath.length() + " changelog length: " + ranChangeSet.getChangeLog().length());
        }
    }

    public RanChangeSet getMatchingIdChangeSet() {
        return this.matchingIdChangeSet;
    }

    public ChangeSet getMatchingChangeSet() {
        return this.changeSet;
    }

    public boolean isEmpty() {
        return this.id == null || this.author == null || this.filePath == null;
    }

    private String createNotFoundErrorMessage(DatabaseChangeLog changeLog, String id, String author, String path) {
        List changeSets = changeLog.getChangeSets();
        String prefix = "\nThe command 'rollbackOneChangeSet' failed because the changeset targeted by '" + id + "::" + author + "::" + path + "'\ncannot be located.  ";
        for (ChangeSet changeSet : changeSets) {
            if (!DatabaseChangeLog.normalizePath((String)changeSet.getFilePath()).equalsIgnoreCase(DatabaseChangeLog.normalizePath((String)path))) {
                return prefix + "The path '" + changeSet.getFilePath() + "' does not resolve to the desired changelog. One solution may be to control the lookup path of\nyour changeLogFile by adding it's base directory to the --classpath flag  and removing any relative path information from the --changeLogFile flag.";
            }
            if (!changeSet.getAuthor().equalsIgnoreCase(author)) {
                return prefix + "The changelog author '" + changeSet.getAuthor() + "' does not match the changeset author '" + author + "'";
            }
            if (!changeSet.getId().equalsIgnoreCase(id)) {
                return prefix + "The changelog ID '" + changeSet.getId() + "' does not match the changeset ID '" + id + "'";
            }
            if (changeLog.isDbmsMatch(changeSet.getDbmsSet())) continue;
            String dbmsString = changeLog.getChangeLogParameters().getValue("database.typeName", changeLog).toString();
            return prefix + "The changelog DBMS: '" + dbmsString + "'  does not match the changeset DBMS '" + changeSet.getDbmsSet().toString() + "'";
        }
        return "";
    }

    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        String changeSetString = changeSet.toString();
        if (this.id.equalsIgnoreCase(changeSet.getId()) && this.author.equalsIgnoreCase(changeSet.getAuthor()) && this.filePath.equals(changeSet.getFilePath())) {
            return new ChangeSetFilterResult(true, "Changeset to rollback is " + changeSetString, this.getClass(), this.getMdcName(), this.getDisplayName());
        }
        return new ChangeSetFilterResult(false, "Changeset " + changeSetString + " will not rollback", this.getClass(), this.getMdcName(), this.getDisplayName());
    }
}

