/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import java.util.List;
import java.util.ResourceBundle;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.EmptyChange;
import liquibase.change.core.RawSQLChange;
import liquibase.change.core.SQLFileChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RollbackContainer;
import liquibase.exception.ValidationErrors;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.license.LicenseServiceUtils;

public class AbstractNativeToolExecutor
extends JdbcExecutor {
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_UNABLE_TO_VALIDATE_CHANGE_SET = coreBundle.getString("unable.to.validate.changeset");
    protected static final String MSG_UNABLE_TO_VALIDATE_LICENSE = coreBundle.getString("no.parameter.pro.license.found");
    protected ChangeSet changeSet;
    private String name;

    public AbstractNativeToolExecutor(String name) {
        this.name = name;
    }

    public ValidationErrors validate(ChangeSet changeSet) {
        if (changeSet.getRunWith() == null || changeSet.getRunWith().isEmpty()) {
            return new ValidationErrors();
        }
        ValidationErrors validationErrors = new ValidationErrors();
        if (!LicenseServiceUtils.isProLicenseValid()) {
            String message = String.format(MSG_UNABLE_TO_VALIDATE_LICENSE, this.getName(), "runWith");
            validationErrors.addError(message);
            return validationErrors;
        }
        List changes = changeSet.getChanges();
        for (Change change : changes) {
            this.validateChange(changeSet, validationErrors, change, "");
        }
        if (changeSet.getRollback() != null) {
            RollbackContainer container = changeSet.getRollback();
            List rollbackChanges = container.getChanges();
            for (Change change : rollbackChanges) {
                this.validateChange(changeSet, validationErrors, change, "rollback");
            }
        }
        this.changeSet = changeSet;
        return validationErrors;
    }

    protected void validateChange(ChangeSet changeSet, ValidationErrors validationErrors, Change change, String type) {
        if (!(change instanceof SQLFileChange || change instanceof RawSQLChange || change instanceof EmptyChange)) {
            String details = "In changeset '" + changeSet.getId() + "::" + changeSet.getAuthor() + "' there is an unsupported change type '" + change.toString() + "'";
            String message = String.format(MSG_UNABLE_TO_VALIDATE_CHANGE_SET, details, type, this.name);
            validationErrors.addError(message);
        }
    }

    public void modifyChangeSet(ChangeSet changeSet) {
        List changes = changeSet.getChanges();
        this.modifyChanges(changes);
        this.changeSet = changeSet;
        if (changeSet.getRollback() == null) {
            return;
        }
        List rollbackChanges = changeSet.getRollback().getChanges();
        this.modifyChanges(rollbackChanges);
    }

    private void modifyChanges(List<Change> changes) {
        for (Change change : changes) {
            if (!(change instanceof AbstractSQLChange)) continue;
            AbstractSQLChange abstractSQLChange = (AbstractSQLChange)change;
            if (!abstractSQLChange.isSplitStatementsSet()) {
                abstractSQLChange.setOriginalSplitStatements(abstractSQLChange.isSplitStatements());
                ((AbstractSQLChange)change).setSplitStatements(Boolean.valueOf(false));
                continue;
            }
            if (!Boolean.TRUE.equals(((AbstractSQLChange)change).isSplitStatements())) continue;
            String changeSetInfoFormat = "%nThe property 'splitStatements=true' is set for 'runWith' changeset 'author:%s', 'id:%s', 'filepath:%s'%n";
            ChangeSet changeSetToCheck = change.getChangeSet();
            String changeSetInfo = String.format(changeSetInfoFormat, changeSetToCheck.getAuthor(), changeSetToCheck.getId(), changeSetToCheck.getFilePath());
            String message = changeSetInfo + System.lineSeparator() + "Setting splitStatements='true' on changesets deployed by " + this.getName() + " may result in unintended consequences." + System.lineSeparator() + "The default is 'splitStatements=false' for 'runWith' changesets." + System.lineSeparator();
            Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
            Scope.getCurrentScope().getLog(AbstractNativeToolExecutor.class).warning(message);
        }
    }
}

