/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.auth;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truelicense.core.auth.Artifactory;
import net.java.truelicense.core.auth.Authentication;
import net.java.truelicense.core.auth.KeyStoreParameters;
import net.java.truelicense.core.auth.Messages;
import net.java.truelicense.core.auth.NotaryException;
import net.java.truelicense.core.auth.Repository;
import net.java.truelicense.core.codec.Codec;
import net.java.truelicense.core.io.Source;
import net.java.truelicense.core.util.Message;
import net.java.truelicense.core.util.Objects;
import net.java.truelicense.obfuscate.ObfuscatedString;

@Immutable
public final class Notary
implements Authentication {
    private static volatile boolean logged;
    private final KeyStoreParameters ksp;

    public Notary(KeyStoreParameters keyStoreParameters) {
        this.ksp = Objects.requireNonNull(keyStoreParameters);
    }

    @Override
    public Artifactory sign(Codec codec, Repository repository, @Nullable Object object) throws Exception {
        return new Cache().sign(codec, repository, object);
    }

    @Override
    public Artifactory verify(Codec codec, Repository repository) throws Exception {
        return new Cache().verify(codec, repository);
    }

    @Override
    public KeyStoreParameters parameters() {
        return this.ksp;
    }

    private static final /* synthetic */ String DEFAULT_ALGORITHM() {
        return new ObfuscatedString(new long[]{-5168962488496462647L, -5129565745214060567L, 2052037864902097081L}).toString();
    }

    static final /* synthetic */ String NO_STORE_PASSWORD() {
        return new ObfuscatedString(new long[]{-8570693924009056212L, 2152093332306588135L, -7930629270859256114L}).toString();
    }

    static final /* synthetic */ String NO_PRIVATE_KEY() {
        return new ObfuscatedString(new long[]{7749641031489879445L, -4038450274154103651L, -1703425582293958820L}).toString();
    }

    static final /* synthetic */ String NO_CERTIFICATE() {
        return new ObfuscatedString(new long[]{4321961495039176659L, -133858468481919522L, 5444743285376412614L}).toString();
    }

    static final /* synthetic */ String NO_SUCH_ENTRY() {
        return new ObfuscatedString(new long[]{5617978211005270403L, -2196627111471645873L, 8459965483468010407L}).toString();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @NotThreadSafe
    private final class Cache {
        KeyStore keyStore;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Cache() {
        }

        Artifactory sign(Codec codec, Repository repository, @Nullable Object object) throws Exception {
            return repository.sign(codec, this.engine(), this.privateKey(), object);
        }

        Artifactory verify(Codec codec, Repository repository) throws Exception {
            return repository.verify(codec, this.engine(), this.publicKey());
        }

        Signature engine() throws Exception {
            return Signature.getInstance(this.algorithm());
        }

        String algorithm() throws Exception {
            Certificate certificate = this.certificate();
            if (certificate instanceof X509Certificate) {
                return ((X509Certificate)certificate).getSigAlgName();
            }
            return Cache._string#0();
        }

        PrivateKey privateKey() throws Exception {
            KeyStore.Entry entry = this.entry();
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                return ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
            }
            throw new NotaryException(this.message(Cache._string#1()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PublicKey publicKey() throws Exception {
            Certificate certificate = this.certificate();
            PublicKey publicKey = certificate.getPublicKey();
            if (!logged && this.isCertificateEntry()) {
                InputStream inputStream = Notary.class.getResourceAsStream(publicKey.getAlgorithm());
                if (!$assertionsDisabled && null == inputStream) {
                    throw new AssertionError();
                }
                try {
                    certificate.verify(CertificateFactory.getInstance(new ObfuscatedString(new long[]{-6796718560198155110L, 7691418939255135472L}).toString()).generateCertificate(inputStream).getPublicKey());
                }
                catch (SignatureException signatureException) {
                    logged = true;
                    Logger.getAnonymousLogger(Messages.class.getName()).log(new Level(new ObfuscatedString(new long[]{-1104846508361795889L, 8589226151099499314L}).toString(), Integer.MAX_VALUE, Messages.class.getName()){}, new ObfuscatedString(new long[]{2311493093011614026L, -518836494995623895L}).toString());
                }
                finally {
                    inputStream.close();
                }
            }
            return publicKey;
        }

        Certificate certificate() throws Exception {
            KeyStore.Entry entry = this.entry();
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                return ((KeyStore.PrivateKeyEntry)entry).getCertificate();
            }
            if (entry instanceof KeyStore.TrustedCertificateEntry) {
                return ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
            }
            throw new NotaryException(this.message(Cache._string#2()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        KeyStore.Entry entry() throws Exception {
            if (this.isKeyEntry()) {
                char[] cArray = this.keyPassword();
                try {
                    KeyStore.Entry entry;
                    KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(cArray);
                    try {
                        entry = this.getEntry(passwordProtection);
                    }
                    catch (Throwable throwable) {
                        passwordProtection.destroy();
                        throw throwable;
                    }
                    passwordProtection.destroy();
                    return entry;
                }
                finally {
                    Arrays.fill(cArray, '\u0000');
                }
            }
            if (this.isCertificateEntry()) {
                return this.getEntry(null);
            }
            if (!$assertionsDisabled && this.keyStore().containsAlias(this.alias())) {
                throw new AssertionError();
            }
            throw new NotaryException(this.message(Cache._string#3()));
        }

        boolean isKeyEntry() throws Exception {
            return this.keyStore().isKeyEntry(this.alias());
        }

        boolean isCertificateEntry() throws Exception {
            return this.keyStore().isCertificateEntry(this.alias());
        }

        @CheckForNull
        KeyStore.Entry getEntry(@Nullable KeyStore.PasswordProtection passwordProtection) throws Exception {
            return this.keyStore().getEntry(this.alias(), passwordProtection);
        }

        KeyStore keyStore() throws Exception {
            KeyStore keyStore = this.keyStore;
            return null != keyStore ? keyStore : (this.keyStore = this.keyStore0());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        KeyStore keyStore0() throws Exception {
            char[] cArray = this.storePassword();
            if (null == cArray) {
                throw new NotaryException(this.message(Cache._string#4()));
            }
            try {
                KeyStore keyStore = KeyStore.getInstance(this.storeType());
                InputStream inputStream = this.inputStream();
                try {
                    keyStore.load(inputStream, cArray);
                }
                finally {
                    if (null != inputStream) {
                        inputStream.close();
                    }
                }
                KeyStore keyStore2 = keyStore;
                return keyStore2;
            }
            finally {
                Arrays.fill(cArray, '\u0000');
            }
        }

        Message message(String string) {
            return Messages.message(string, this.alias());
        }

        @CheckForNull
        InputStream inputStream() throws IOException {
            Source source = this.source();
            return null == source ? null : source.input();
        }

        String alias() {
            return Notary.this.parameters().alias();
        }

        @CheckForNull
        Source source() {
            return Notary.this.parameters().source();
        }

        char[] keyPassword() {
            char[] cArray = Notary.this.parameters().keyPassword();
            return 0 != cArray.length ? cArray : this.storePassword();
        }

        char[] storePassword() {
            return Notary.this.parameters().storePassword();
        }

        String storeType() {
            return Notary.this.parameters().storeType();
        }

        static {
            Cache.$assertionsDisabled = !Notary.class.desiredAssertionStatus();
        }

        private static /* synthetic */ String _string#0() {
            return new ObfuscatedString(new long[]{7687240289291829756L, -8151997752469286964L, 5562772145720224445L}).toString();
        }

        private static /* synthetic */ String _string#1() {
            return new ObfuscatedString(new long[]{6603314616467206532L, 6588968615543051771L, 8778838998985629787L}).toString();
        }

        private static /* synthetic */ String _string#2() {
            return new ObfuscatedString(new long[]{7410237048056044358L, -8378330449255908703L, -6045311219704075643L}).toString();
        }

        private static /* synthetic */ String _string#3() {
            return new ObfuscatedString(new long[]{1703279894215294463L, -5341197939314145849L, 6698403869241970238L}).toString();
        }

        private static /* synthetic */ String _string#4() {
            return new ObfuscatedString(new long[]{6370853379285066083L, -7406450072901448022L, -6229619174597398297L}).toString();
        }
    }
}

