/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.type;

import com.datical.liquibase.ext.appdba.type.AlterCompositeTypeAttributesChange;
import com.datical.liquibase.ext.appdba.type.CompositeType;
import com.datical.liquibase.ext.appdba.type.DataTypeAttribute;
import com.datical.liquibase.ext.appdba.type.dto.AlterDataTypeAttribute;
import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackageBody;
import com.datical.liquibase.ext.storedlogic.function.Function;
import java.util.Collections;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.Difference;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredProcedure;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;

public class ChangedDataTypeAttributeChangeGenerator
extends LicenseCheckingChangeGenerator
implements ChangedObjectChangeGenerator {
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_COLLATION = "collation";

    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (DataTypeAttribute.class.isAssignableFrom(objectType)) {
            return super.getPriority(objectType, database);
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{CompositeType.class};
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{Table.class, View.class, DatabasePackage.class, DatabasePackageBody.class, StoredProcedure.class, Function.class};
    }

    public Change[] fixChanged(DatabaseObject changedObject, ObjectDifferences differences, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        if (differences.isDifferent("order") && differences.getDifferences().size() == 1) {
            return new Change[0];
        }
        DataTypeAttribute typeAttribute = (DataTypeAttribute)changedObject;
        CompositeType parentType = typeAttribute.getParentType();
        AlterCompositeTypeAttributesChange change = new AlterCompositeTypeAttributesChange();
        change.setTypeName(parentType.getName());
        if (control.getIncludeCatalog()) {
            change.setCatalogName(parentType.getSchema().getCatalogName());
        }
        if (control.getIncludeSchema()) {
            change.setSchemaName(parentType.getSchema().getName());
        }
        AlterDataTypeAttribute alterDataTypeAttribute = new AlterDataTypeAttribute();
        alterDataTypeAttribute.setName(typeAttribute.getName());
        if (differences.isDifferent(ATTRIBUTE_TYPE)) {
            Difference attributeTypeDifference = differences.getDifference(ATTRIBUTE_TYPE);
            alterDataTypeAttribute.setNewType(attributeTypeDifference.getReferenceValue().toString());
            alterDataTypeAttribute.setCollation(typeAttribute.getCollation());
        }
        if (differences.isDifferent(ATTRIBUTE_COLLATION)) {
            Difference attributeCollationDifference = differences.getDifference(ATTRIBUTE_COLLATION);
            Object referenceCollation = attributeCollationDifference.getReferenceValue();
            String newCollation = referenceCollation == null || "null".equalsIgnoreCase((String)referenceCollation) ? null : referenceCollation.toString();
            alterDataTypeAttribute.setCollation(newCollation);
            if (!differences.isDifferent(ATTRIBUTE_TYPE)) {
                alterDataTypeAttribute.setNewType(typeAttribute.getType());
            }
        }
        change.setAlterAttributes(Collections.singletonList(alterDataTypeAttribute));
        return new Change[]{change};
    }
}

