/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.type;

import com.datical.liquibase.ext.appdba.type.CompositeType;
import com.datical.liquibase.ext.appdba.type.DataTypeAttribute;
import com.datical.liquibase.ext.license.LicenseCheckingSnapshotGenerator;
import com.datical.liquibase.ext.util.CachedQueryUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.util.StringUtil;

public class CompositeTypeSnapshotGenerator
extends LicenseCheckingSnapshotGenerator {
    private final Set<String> postgresSystemSchemas = new HashSet<String>(Arrays.asList("PG_CATALOG", "INFORMATION_SCHEMA"));

    public CompositeTypeSnapshotGenerator() {
        super(CompositeType.class, new Class[]{Schema.class});
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof PostgresDatabase && !(database instanceof CockroachDatabase) && !(database instanceof EnterpriseDBDatabase)) {
            return super.getPriority(objectType, database);
        }
        return -1;
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (foundObject instanceof Schema) {
            String sql;
            Database database = snapshot.getDatabase();
            String schemaName = ((Schema)foundObject).toCatalogAndSchema().customize(database).getSchemaName();
            boolean fetchedAcrossSchemas = false;
            if (database instanceof PostgresDatabase) {
                String allCatalogs = (String)snapshot.getScratchData("DatabaseSnapshot.allCatalogsString");
                sql = "SELECT\n    UDT_CATALOG AS CATALOG_NAME,\n    UDT_SCHEMA AS SCHEMA_NAME,\n    UDT_NAME AS COMPOSITE_NAME,\n    ATTRIBUTE_NAME,\n    DATA_TYPE,\n    COLLATION_NAME AS COLLATION,\n    ORDINAL_POSITION AS ATTRIBUTE_POSITION\nFROM INFORMATION_SCHEMA.ATTRIBUTES\n";
                sql = allCatalogs == null ? sql + "WHERE UDT_CATALOG = CURRENT_CATALOG\n" : sql + "WHERE UDT_CATALOG IN (" + allCatalogs + "')\n";
                if (schemaName != null) {
                    sql = sql + "  AND UDT_SCHEMA = '" + schemaName + "' \n";
                }
            } else {
                throw new UnexpectedLiquibaseException("Unexpected database: " + database.getShortName());
            }
            sql = sql + "  AND UDT_SCHEMA NOT IN ('" + StringUtil.join(this.postgresSystemSchemas, (String)"', '") + "')\n  AND UDT_NAME IN (SELECT TYPNAME FROM PG_CATALOG.PG_TYPE WHERE TYPTYPE = 'c')\nORDER BY UDT_CATALOG, UDT_SCHEMA, UDT_NAME, ORDINAL_POSITION;";
            List<Map<String, ?>> rs = CachedQueryUtil.queryIfNotCached(fetchedAcrossSchemas, sql, "CompositeTypeSnapshotGenerator.allRows", snapshot);
            String previousRowFullName = null;
            CompositeType currentType = null;
            for (Map<String, ?> row : rs) {
                String typeName = (String)row.get("COMPOSITE_NAME");
                String typeCatalogName = (String)row.get("CATALOG_NAME");
                String typeSchemaName = (String)row.get("SCHEMA_NAME");
                String currentRowFullName = typeCatalogName + typeSchemaName + typeName;
                if (previousRowFullName == null || !previousRowFullName.equals(currentRowFullName)) {
                    currentType = new CompositeType();
                    currentType.setName(typeName).setSchema(new Schema(typeCatalogName, typeSchemaName));
                    ((Schema)foundObject).addDatabaseObject((DatabaseObject)currentType);
                }
                DataTypeAttribute currentAttribute = new DataTypeAttribute();
                currentAttribute.setName((String)row.get("ATTRIBUTE_NAME"));
                currentAttribute.setType((String)row.get("DATA_TYPE"));
                currentAttribute.setOrder((Integer)row.get("ATTRIBUTE_POSITION"));
                if (null != row.get("COLLATION")) {
                    currentAttribute.setCollation((String)row.get("COLLATION"));
                }
                currentType.setTypeAttribute(currentAttribute);
                previousRowFullName = currentRowFullName;
            }
        }
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws InvalidExampleException {
        if (example instanceof CompositeType) {
            return example;
        }
        throw new InvalidExampleException("Could not process found example of " + example.getObjectTypeName() + " type");
    }
}

