/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.type;

import com.datical.liquibase.ext.appdba.type.AlterCompositeTypeAttributesChange;
import com.datical.liquibase.ext.appdba.type.CompositeType;
import com.datical.liquibase.ext.appdba.type.DataTypeAttribute;
import com.datical.liquibase.ext.appdba.type.dto.AddDataTypeAttribute;
import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackageBody;
import com.datical.liquibase.ext.storedlogic.function.Function;
import java.util.Collections;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredProcedure;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;

public class MissingDataTypeAttributeChangeGenerator
extends LicenseCheckingChangeGenerator
implements MissingObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (DataTypeAttribute.class.isAssignableFrom(objectType)) {
            return super.getPriority(objectType, database);
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{CompositeType.class};
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{Table.class, View.class, DatabasePackage.class, DatabasePackageBody.class, StoredProcedure.class, Function.class};
    }

    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        DataTypeAttribute typeAttribute = (DataTypeAttribute)missingObject;
        CompositeType parentType = typeAttribute.getParentType();
        AlterCompositeTypeAttributesChange change = new AlterCompositeTypeAttributesChange();
        change.setTypeName(parentType.getName());
        if (control.getIncludeCatalog()) {
            change.setCatalogName(parentType.getSchema().getCatalogName());
        }
        if (control.getIncludeSchema()) {
            change.setSchemaName(parentType.getSchema().getName());
        }
        AddDataTypeAttribute addTypeAttribute = new AddDataTypeAttribute();
        addTypeAttribute.setType(typeAttribute.getType());
        addTypeAttribute.setName(typeAttribute.getName());
        addTypeAttribute.setCollation(typeAttribute.getCollation());
        change.setAddAttributes(Collections.singletonList(addTypeAttribute));
        return new Change[]{change};
    }
}

