/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.type;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.statement.compositetype.RenameCompositeTypeAttributeStatement;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.license.pro.LicenseTier;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="renameCompositeTypeAttribute", description="Alter Composite Type to change one of its attribute name", priority=5)
public class RenameCompositeTypeAttributeChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String typeName;
    private String oldAttributeName;
    private String newAttributeName;
    private String onUpdate;

    public boolean supports(Database database) {
        return database instanceof PostgresDatabase;
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors errors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
        if (errors.hasErrors()) {
            return errors;
        }
        return super.validate(database);
    }

    public String getConfirmationMessage() {
        return "Attribute '" + this.oldAttributeName + "' for Composite type '" + this.typeName + "' renamed to '" + this.newAttributeName + "'";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new RenameCompositeTypeAttributeStatement(this.catalogName, this.schemaName, this.typeName, this.oldAttributeName, this.newAttributeName, this.onUpdate)};
    }

    protected Change[] createInverses() {
        RenameCompositeTypeAttributeChange inverse = new RenameCompositeTypeAttributeChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setCatalogName(this.getCatalogName());
        inverse.setTypeName(this.getTypeName());
        inverse.setOldAttributeName(this.getNewAttributeName());
        inverse.setNewAttributeName(this.getOldAttributeName());
        inverse.setOnUpdate(this.getOnUpdate());
        return new Change[]{inverse};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    public void setOldAttributeName(String oldAttributeName) {
        this.oldAttributeName = oldAttributeName;
    }

    @Generated
    public void setNewAttributeName(String newAttributeName) {
        this.newAttributeName = newAttributeName;
    }

    @Generated
    public void setOnUpdate(String onUpdate) {
        this.onUpdate = onUpdate;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public String getOldAttributeName() {
        return this.oldAttributeName;
    }

    @Generated
    public String getNewAttributeName() {
        return this.newAttributeName;
    }

    @Generated
    public String getOnUpdate() {
        return this.onUpdate;
    }
}

