/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.type;

import com.datical.liquibase.ext.appdba.type.AlterCompositeTypeAttributesChange;
import com.datical.liquibase.ext.appdba.type.CompositeType;
import com.datical.liquibase.ext.appdba.type.DataTypeAttribute;
import com.datical.liquibase.ext.appdba.type.dto.DropDataTypeAttribute;
import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import java.util.Collections;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.structure.DatabaseObject;

public class UnexpectedDataTypeAttributeChangeGenerator
extends LicenseCheckingChangeGenerator
implements UnexpectedObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (DataTypeAttribute.class.isAssignableFrom(objectType)) {
            return super.getPriority(objectType, database);
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{CompositeType.class};
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[0];
    }

    public Change[] fixUnexpected(DatabaseObject unexpectedObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        DataTypeAttribute typeAttribute = (DataTypeAttribute)unexpectedObject;
        CompositeType parentType = typeAttribute.getParentType();
        AlterCompositeTypeAttributesChange change = new AlterCompositeTypeAttributesChange();
        change.setTypeName(parentType.getName());
        if (control.getIncludeCatalog()) {
            change.setCatalogName(parentType.getSchema().getCatalogName());
        }
        if (control.getIncludeSchema()) {
            change.setSchemaName(parentType.getSchema().getName());
        }
        DropDataTypeAttribute dropTypeAttribute = new DropDataTypeAttribute();
        dropTypeAttribute.setName(typeAttribute.getName());
        change.setDropAttributes(Collections.singletonList(dropTypeAttribute));
        return new Change[]{change};
    }
}

