/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog;

import com.datical.liquibase.ext.changelog.AbstractChangelogRewriter;
import com.datical.liquibase.ext.changelog.ChangelogRewriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.IncludeAllFilter;
import liquibase.exception.LiquibaseException;
import liquibase.exception.SetupException;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;

public class XMLChangelogRewriter
extends AbstractChangelogRewriter {
    private static final String XML_CHANGE_SET_REGEX = "(<changeSet [^>]*+>.*?$)";
    private static final Pattern XML_CHANGE_SET_PATTERN = Pattern.compile("(<changeSet [^>]*+>.*?$)", 40);
    private static final String XML_CHANGE_SET_IGNORE_REGEX = ".*?<changeSet.*?ignore=\"(.*?)\"[^>]*+>";
    private static final Pattern XML_CHANGE_SET_IGNORE_PATTERN = Pattern.compile(".*?<changeSet.*?ignore=\"(.*?)\"[^>]*+>", 40);
    private static final String XML_CHANGE_SET_DBMS_REGEX = ".*?<changeSet.*?dbms=\"(.*?)\"[^>]*+>";
    private static final Pattern XML_CHANGE_SET_DBMS_PATTERN = Pattern.compile(".*?<changeSet.*?dbms=\"(.*?)\"[^>]*+>", 40);
    private static final String XML_CHANGE_SET_ID_REGEX = " id=\"(.*?)\"";
    private static final Pattern XML_CHANGE_SET_ID_PATTERN = Pattern.compile(" id=\"(.*?)\"", 40);
    private static final String XML_CHANGE_SET_AUTHOR_REGEX = " author=\"(.*?)\"";
    private static final Pattern XML_CHANGE_SET_AUTHOR_PATTERN = Pattern.compile(" author=\"(.*?)\"", 40);
    private static final String XML_LABELS_REGEX = " labels=\"(.*?)\"";
    private static final Pattern XML_LABELS_PATTERN = Pattern.compile(" labels=\"(.*?)\"", 40);
    private static final String XML_CONTEXT_REGEX = " context=\"(.*?)\"";
    private static final Pattern XML_CONTEXT_PATTERN = Pattern.compile(" context=\"(.*?)\"", 2);
    private static final String XML_CONTEXT_FILTER_REGEX = " contextFilter=\"(.*?)\"";
    private static final Pattern XML_CONTEXT_FILTER_PATTERN = Pattern.compile(" contextFilter=\"(.*?)\"", 2);
    private static final String XML_DATABASECHANGELOG_REGEX = ".*?<databaseChangeLog.*?logicalFilePath=\"(.*?)\"[^>]*+>";
    private static final Pattern XML_DATABASECHANGELOG_PATTERN = Pattern.compile(".*?<databaseChangeLog.*?logicalFilePath=\"(.*?)\"[^>]*+>", 40);
    private static final String XML_INCLUDE_REGEX = "(<include .*?[^>]*+>)";
    private static final Pattern XML_INCLUDE_PATTERN = Pattern.compile("(<include .*?[^>]*+>)", 40);
    private static final String XML_INCLUDE_FILE_REGEX = ".*?file=\"(.*?)\"[^>]*+>";
    private static final Pattern XML_INCLUDE_FILE_PATTERN = Pattern.compile(".*?file=\"(.*?)\"[^>]*+>", 40);
    private static final String XML_INCLUDE_IGNORE_REGEX = "<include .*?ignore=\"(.*?)\"[^>]*+>";
    private static final Pattern XML_INCLUDE_IGNORE_PATTERN = Pattern.compile("<include .*?ignore=\"(.*?)\"[^>]*+>", 40);
    private static final String XML_INCLUDE_ALL_IGNORE_REGEX = "<includeAll .*?ignore=\"(.*?)\"[^>]*+>";
    private static final Pattern XML_INCLUDE_ALL_IGNORE_PATTERN = Pattern.compile("<includeAll .*?ignore=\"(.*?)\"[^>]*+>", 40);
    private static final String XML_INCLUDE_ALL_REGEX = "<includeAll (.*?)>";
    private static final Pattern XML_INCLUDE_ALL_PATTERN = Pattern.compile("<includeAll (.*?)>", 40);
    private static final String XML_INCLUDE_ALL_PATH_REGEX = ".*?path=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_PATH_PATTERN = Pattern.compile(".*?path=\"(.*?)\"[^>]*+", 40);
    private static final String XML_INCLUDE_ALL_FILTER_REGEX = ".*?filter=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_FILTER_PATTERN = Pattern.compile(".*?filter=\"(.*?)\"[^>]*+", 40);
    private static final String XML_INCLUDE_ALL_RELATIVE_TO_CHANGELOG_FILE_REGEX = ".*?relativeToChangelogFile=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_RELATIVE_TO_CHANGELOG_FILE_PATTERN = Pattern.compile(".*?relativeToChangelogFile=\"(.*?)\"[^>]*+", 40);
    private static final String XML_INCLUDE_ALL_ERROR_IF_MISSING_OR_EMPTY_REGEX = ".*?errorIfMissingOrEmpty=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_ERROR_IF_MISSING_OR_EMPTY_PATTERN = Pattern.compile(".*?errorIfMissingOrEmpty=\"(.*?)\"[^>]*+", 40);
    private static final String XML_INCLUDE_ALL_MIN_DEPTH_REGEX = ".*?minDepth=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_MIN_DEPTH_PATTERN = Pattern.compile(".*?minDepth=\"(.*?)\"[^>]*+", 40);
    private static final String XML_INCLUDE_ALL_MAX_DEPTH_REGEX = ".*?maxDepth=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_MAX_DEPTH_PATTERN = Pattern.compile(".*?maxDepth=\"(.*?)\"[^>]*+", 40);
    private static final String XML_INCLUDE_ALL_RESOURCE_FILTER_REGEX = ".*?resourceFilter=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_RESOURCE_FILTER_PATTERN = Pattern.compile(".*?resourceFilter=\"(.*?)\"[^>]*+", 40);
    private static final String XML_INCLUDE_ALL_RESOURCE_COMPARATOR_REGEX = ".*?resourceComparator=\"(.*?)\"[^>]*+";
    private static final Pattern XML_INCLUDE_ALL_RESOURCE_COMPARATOR_PATTERN = Pattern.compile(".*?resourceComparator=\"(.*?)\"[^>]*+", 40);
    public static final String LABELS_TAG = " labels=\"";
    public static final String CONTEXT_TAG = " context=\"";
    public static final String CONTEXT_FILTER_TAG = " contextFilter=\"";
    public static final String XML_COMMENT_REGEX = "(?s)<!--.*?-->";
    public static final Pattern XML_COMMENT_PATTERN = Pattern.compile("(?s)<!--.*?-->", 40);
    private final Map<Integer, Integer> commentPositions = new HashMap<Integer, Integer>();

    @Override
    public boolean supports(String path) {
        return path.toLowerCase().endsWith(".xml");
    }

    @Override
    public String handle(String changelogString) throws LiquibaseException {
        String newChangeLogString = changelogString;
        Matcher commentMatcher = XML_COMMENT_PATTERN.matcher(changelogString);
        while (commentMatcher.find()) {
            this.commentPositions.put(commentMatcher.start(), commentMatcher.end());
        }
        Matcher changesetMatcher = XML_CHANGE_SET_PATTERN.matcher(changelogString);
        while (changesetMatcher.find()) {
            String changeSetString = changesetMatcher.group(1);
            String id = this.getFirstGroupValue(changeSetString, XML_CHANGE_SET_ID_PATTERN);
            String author = this.getFirstGroupValue(changeSetString, XML_CHANGE_SET_AUTHOR_PATTERN);
            String path = this.determinePath(newChangeLogString);
            String ignoreMessage = "Ignoring changeset '" + id + "::" + author + "::" + path + "'";
            String dbmsMessage = "Mismatched dbms for changeset '" + id + "::" + author + "::" + path + "'";
            Matcher changesetIgnoreMatcher = XML_CHANGE_SET_IGNORE_PATTERN.matcher(changeSetString);
            Matcher changesetDbmsMatcher = XML_CHANGE_SET_DBMS_PATTERN.matcher(changeSetString);
            if (this.isComment(changesetMatcher.start(), changesetMatcher.end(), ignoreMessage) || this.isIgnored(changeSetString, changesetIgnoreMatcher, ignoreMessage) || !this.isDbmsMatch(changeSetString, changesetDbmsMatcher, dbmsMessage)) continue;
            Matcher matcher = this.modType == ChangelogRewriter.MOD_TYPE.LABELS ? XML_LABELS_PATTERN.matcher(changeSetString) : this.getContextMatcher(changeSetString);
            String fileValue = null;
            if (matcher.find()) {
                fileValue = matcher.group(1);
            }
            int delta = newChangeLogString.length() - changelogString.length();
            newChangeLogString = this.modifyValueInXML(newChangeLogString, changeSetString, fileValue, changesetMatcher.start() + delta, changesetMatcher.end() + delta);
        }
        this.handleInclude(changelogString);
        this.handleIncludes(changelogString);
        return newChangeLogString;
    }

    private boolean isComment(int start, int end, String message) {
        for (Map.Entry<Integer, Integer> entry : this.commentPositions.entrySet()) {
            if (start < entry.getKey() || end > entry.getValue()) continue;
            Scope.getCurrentScope().getLog(XMLChangelogRewriter.class).info(message);
            return true;
        }
        return false;
    }

    private Matcher getContextMatcher(String changeSetString) {
        if (changeSetString.contains("contextFilter")) {
            return XML_CONTEXT_FILTER_PATTERN.matcher(changeSetString);
        }
        return XML_CONTEXT_PATTERN.matcher(changeSetString);
    }

    private void handleInclude(String changelogString) throws LiquibaseException {
        Matcher includeTagMatcher = XML_INCLUDE_PATTERN.matcher(changelogString);
        while (includeTagMatcher.find()) {
            String includePath;
            String includeString = includeTagMatcher.group(1);
            Matcher includeFileMatcher = XML_INCLUDE_FILE_PATTERN.matcher(includeString);
            if (!includeFileMatcher.find() || (includePath = includeFileMatcher.group(1)) == null) continue;
            Matcher includeIgnoreMatcher = XML_INCLUDE_IGNORE_PATTERN.matcher(includeString);
            if (this.isComment(includeTagMatcher.start(), includeTagMatcher.end(), "Ignoring commented include file '" + includePath + "'") || this.isIgnored(includeString, includeIgnoreMatcher, "Ignoring include file '" + includePath + "'")) continue;
            this.handleIncludedFile(includePath);
        }
    }

    private boolean isIgnored(String stringToMatchOn, Matcher ignoreMatcher, String message) {
        String ignoreString;
        if (!stringToMatchOn.contains(" ignore")) {
            return false;
        }
        if (ignoreMatcher.find() && Boolean.parseBoolean(ignoreString = ignoreMatcher.group(1))) {
            Scope.getCurrentScope().getUI().sendMessage(message);
            return true;
        }
        return false;
    }

    private boolean isDbmsMatch(String stringToMatchOn, Matcher dbmsMatcher, String message) {
        String dbmsString;
        if (!stringToMatchOn.contains(" dbms")) {
            return true;
        }
        if (dbmsMatcher.find() && !this.databaseChangelog.isDbmsMatch(dbmsString = dbmsMatcher.group(1))) {
            Scope.getCurrentScope().getUI().sendMessage(message);
            return false;
        }
        return true;
    }

    @Override
    protected void handleIncludes(String changelogString) throws SetupException {
        Matcher includeAllTagMatcher = XML_INCLUDE_ALL_PATTERN.matcher(changelogString);
        while (includeAllTagMatcher.find()) {
            String includeAllString = includeAllTagMatcher.group(1);
            String includeAllPath = this.getFirstGroupValue(includeAllString, XML_INCLUDE_ALL_PATH_PATTERN);
            String message = "Ignoring commented includeAll path '" + includeAllPath + "'";
            Matcher includeAllIgnoreMatcher = XML_INCLUDE_ALL_IGNORE_PATTERN.matcher(includeAllString);
            if (this.isComment(includeAllTagMatcher.start(), includeAllTagMatcher.end(), message) || this.isIgnored(includeAllString, includeAllIgnoreMatcher, message)) continue;
            boolean errorIfMissingOrEmpty = false;
            String errorIfMissingOrEmptyString = this.getFirstGroupValue(includeAllString, XML_INCLUDE_ALL_ERROR_IF_MISSING_OR_EMPTY_PATTERN);
            if (errorIfMissingOrEmptyString != null) {
                errorIfMissingOrEmpty = Boolean.parseBoolean(errorIfMissingOrEmptyString);
            }
            SortedSet<Resource> resources = this.findResources(includeAllString, includeAllPath, errorIfMissingOrEmpty);
            this.handleFoundResources(includeAllPath, errorIfMissingOrEmpty, resources);
        }
    }

    private SortedSet<Resource> findResources(String includeAllTagString, String includeAllPath, boolean errorIfMissingOrEmpty) throws SetupException {
        String resourceFilterDef = this.getFirstGroupValue(includeAllTagString, XML_INCLUDE_ALL_FILTER_PATTERN);
        if (resourceFilterDef == null) {
            resourceFilterDef = this.getFirstGroupValue(includeAllTagString, XML_INCLUDE_ALL_RESOURCE_FILTER_PATTERN);
        }
        IncludeAllFilter resourceFilter = this.getIncludeAllFilter(resourceFilterDef);
        String resourceComparatorDef = this.getFirstGroupValue(includeAllTagString, XML_INCLUDE_ALL_RESOURCE_COMPARATOR_PATTERN);
        Comparator<String> resourceComparator = this.getResourceComparator(resourceComparatorDef);
        int minDepth = 1;
        String minDepthString = this.getFirstGroupValue(includeAllTagString, XML_INCLUDE_ALL_MIN_DEPTH_PATTERN);
        if (minDepthString != null) {
            minDepth = Integer.parseInt(minDepthString);
        }
        int maxDepth = Integer.MAX_VALUE;
        String maxDepthString = this.getFirstGroupValue(includeAllTagString, XML_INCLUDE_ALL_MAX_DEPTH_PATTERN);
        if (maxDepthString != null) {
            maxDepth = Integer.parseInt(maxDepthString);
        }
        boolean isRelativeToChangelogFile = false;
        String isRelativeToChangelogFileString = this.getFirstGroupValue(includeAllTagString, XML_INCLUDE_ALL_RELATIVE_TO_CHANGELOG_FILE_PATTERN);
        if (isRelativeToChangelogFileString != null) {
            isRelativeToChangelogFile = Boolean.parseBoolean(isRelativeToChangelogFileString);
        }
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        return this.databaseChangelog.findResources(includeAllPath, isRelativeToChangelogFile, resourceFilter, errorIfMissingOrEmpty, resourceComparator, resourceAccessor, minDepth, maxDepth);
    }

    private String modifyValueInXML(String newChangeLogString, String changeSetString, String fileValue, int start, int end) {
        String id = this.getFirstGroupValue(changeSetString, XML_CHANGE_SET_ID_PATTERN);
        String author = this.getFirstGroupValue(changeSetString, XML_CHANGE_SET_AUTHOR_PATTERN);
        String path = this.determinePath(newChangeLogString);
        ChangeSet changeSet = this.databaseChangelog.getChangeSet(path, author, id);
        if (changeSet != null) {
            String newValue;
            String string = newValue = this.modType == ChangelogRewriter.MOD_TYPE.LABELS ? changeSet.getLabels().toString() : this.createContextStringForFile(changeSet);
            if (StringUtil.isNotEmpty((String)newValue) && (fileValue == null || !fileValue.equals(newValue))) {
                String newChangeSetString = this.rewriteValueInXML(changeSetString, fileValue, newValue);
                newChangeLogString = newChangeLogString.substring(0, start) + newChangeSetString + newChangeLogString.substring(end);
            }
        }
        return newChangeLogString;
    }

    @Override
    protected String determinePath(String newChangeLogString) {
        String logicalFilePath;
        String path = this.includedPath != null ? ((logicalFilePath = this.getFirstGroupValue(newChangeLogString, XML_DATABASECHANGELOG_PATTERN)) != null ? logicalFilePath : this.includedPath) : this.getPath(this.databaseChangelog);
        return path;
    }

    private String rewriteValueInXML(String changeSetString, String fileValue, String newValue) {
        String newChangeSetString = this.modType == ChangelogRewriter.MOD_TYPE.LABELS ? (fileValue == null ? changeSetString.replace(">", LABELS_TAG + newValue + "\">") : changeSetString.replace(LABELS_TAG + fileValue + "\"", LABELS_TAG + newValue + "\"")) : (fileValue == null ? changeSetString.replace(">", CONTEXT_TAG + newValue + "\">") : (changeSetString.contains(CONTEXT_FILTER_TAG) ? changeSetString.replace(CONTEXT_FILTER_TAG + fileValue + "\"", CONTEXT_FILTER_TAG + newValue + "\"") : changeSetString.replace(CONTEXT_TAG + fileValue + "\"", CONTEXT_TAG + newValue + "\"")));
        return newChangeSetString;
    }
}

