/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.database.core;

import liquibase.Scope;
import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.exception.CommandValidationException;
import liquibase.exception.ValidationErrors;
import liquibase.license.LicenseServiceUtils;
import org.apache.commons.lang3.StringUtils;

public class ProDb2zConfiguration
implements AutoloadedConfigurations {
    public static final String LIQUIBASE_DB2Z_NAMESPACE = "liquibase.db2z";
    public static final ConfigurationDefinition<String> CHANGELOG_TABLES_DATABASE;
    public static final ConfigurationDefinition<String> CHANGELOG_TABLES_TABLESPACE;
    public static final ConfigurationDefinition<String> DATABASECHANGELOG_INDEX;
    public static final ConfigurationDefinition<String> DATABASECHANGELOGLOCK_INDEX;

    public static String validateLicenseForProperty(String propertyValue, String propertyName) {
        if (propertyValue != null && !propertyValue.isEmpty() && !LicenseServiceUtils.isProLicenseValid()) {
            Scope.getCurrentScope().getLog(ProDb2zConfiguration.class).warning("The DB2z configuration property '" + propertyName + "' requires a valid Liquibase Pro license. Visit https://www.liquibase.com/purchase to purchase a license.");
        }
        return propertyValue;
    }

    public static void checkProLicenseForDb2zFeatures() throws CommandValidationException {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])new String[]{"DB2z custom configuration"});
    }

    public static ValidationErrors validateTrackingTablesLocationConsistency() {
        boolean hasTablespace;
        ValidationErrors validationErrors = new ValidationErrors();
        String database = (String)CHANGELOG_TABLES_DATABASE.getCurrentValue();
        String tablespace = (String)CHANGELOG_TABLES_TABLESPACE.getCurrentValue();
        boolean hasDatabase = StringUtils.isNotEmpty((CharSequence)database);
        if (hasDatabase != (hasTablespace = StringUtils.isNotEmpty((CharSequence)tablespace))) {
            String errorMessage = "The DB2z tracking tables location properties must be specified together. Either provide both '" + CHANGELOG_TABLES_DATABASE.getKey() + "' and '" + CHANGELOG_TABLES_TABLESPACE.getKey() + "', or leave both unspecified.";
            validationErrors.addError(errorMessage);
            Scope.getCurrentScope().getLog(ProDb2zConfiguration.class).warning(errorMessage);
        }
        return validationErrors;
    }

    static {
        try {
            ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder(LIQUIBASE_DB2Z_NAMESPACE);
            CHANGELOG_TABLES_DATABASE = builder.define("trackingTables.location.database", String.class).setDescription("The database name for the Liquibase tracking tables on DB2 z/OS").build();
            CHANGELOG_TABLES_TABLESPACE = builder.define("trackingTables.location.tablespace", String.class).setDescription("The tablespace name for the Liquibase tracking tables on DB2 z/OS").build();
            DATABASECHANGELOG_INDEX = builder.define("databasechangelog.index", String.class).setDescription("The index name for the DATABASECHANGELOG table on DB2 z/OS").build();
            DATABASECHANGELOGLOCK_INDEX = builder.define("databasechangeloglock.index", String.class).setDescription("The index name for the DATABASECHANGELOGLOCK table on DB2 z/OS").build();
        }
        catch (Exception e) {
            System.err.println("Error initializing ProDb2zConfiguration: " + e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("Error initializing ProDb2zConfiguration", e);
        }
    }
}

