/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.database.jvm;

import com.datical.liquibase.ext.config.LiquibaseSnowflakeConfiguration;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import com.datical.liquibase.ext.util.SnowflakeProJdbcConnectionUtil;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import liquibase.Scope;
import liquibase.exception.DatabaseException;

public class SnowflakeProJdbcConnection
extends ProJdbcConnection {
    private static final String PKI_AUTH_TYPE = "PKI";
    private static final String OAUTH_AUTH_TYPE = "OAUTH";

    public SnowflakeProJdbcConnection() {
    }

    public SnowflakeProJdbcConnection(Connection connection) {
        super(connection);
    }

    @Override
    public int getPriority() {
        return super.getPriority() + 1;
    }

    @Override
    public void open(String url, Driver driverObject, Properties driverProperties) throws DatabaseException {
        String authType = (String)LiquibaseSnowflakeConfiguration.AUTHENTICATION_TYPE.getCurrentValue();
        if (PKI_AUTH_TYPE.equalsIgnoreCase(authType)) {
            driverProperties.put("privateKey", SnowflakeProJdbcConnectionUtil.getPrivateKey());
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Attempting PKI connection to Snowflake with URL: " + url);
        }
        if (OAUTH_AUTH_TYPE.equalsIgnoreCase(authType)) {
            String token = (String)LiquibaseSnowflakeConfiguration.AUTHENTICATION_TOKEN.getCurrentValue();
            SnowflakeProJdbcConnectionUtil.throwIfNotPresent(token, "OAuth authentication type was specified, but token was not provided. Please provide one in the 'snowflake-auth-token' configuration.");
            driverProperties.put("authenticator", "oauth");
            driverProperties.put("token", token);
        }
        driverProperties.put("application", "Liquibase");
        super.open(url, driverObject, driverProperties);
    }

    public boolean supports(String url) {
        return url.contains("snowflake");
    }
}

