/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.action;

import com.datical.liquibase.ext.config.LiquibaseFlowConfiguration;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import java.util.HashMap;
import java.util.Map;
import liquibase.Scope;
import liquibase.command.CommandResultsBuilder;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.util.CollectionUtil;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ExitCommandAction
extends Action {
    private Map<String, Object> cmdArgs = new HashMap<String, Object>();
    private static final String CMD_ARGS = "cmdArgs";

    public Map<String, Object> getCmdArgs() {
        return this.cmdArgs;
    }

    public String toString() {
        if (Boolean.TRUE.equals(LiquibaseFlowConfiguration.FLOW_VERBOSE_TO_STRING.getCurrentValue())) {
            return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
        }
        return String.format("'%s' %s", this.getType(), this.getCommand());
    }

    public void setCmdArgs(Map<String, Object> cmdArgs) {
        this.cmdArgs = cmdArgs;
    }

    @Override
    public String getCommand() {
        return "exit";
    }

    @Override
    public String getType() {
        return "control";
    }

    @Override
    public Action fromAction(Map<String, Object> actionMap, Map<String, Object> variables) {
        ExitCommandAction exitCommandAction = new ExitCommandAction();
        exitCommandAction.setCmdArgs(FlowVariableExpander.expandVariables((Map)actionMap.get(CMD_ARGS), variables));
        return exitCommandAction;
    }

    @Override
    public void validate(String flowFileArg) throws CommandExecutionException {
        if (this.cmdArgs == null || this.cmdArgs.isEmpty()) {
            return;
        }
        String exitStatusKey = CollectionUtil.findKeyInMapIgnoreCase((String)"exitCode", this.cmdArgs);
        Boolean continueOnError = this.getContinueOnError();
        if (Boolean.TRUE.equals(continueOnError)) {
            throw new CommandValidationException("Cannot set 'continueOnError' to true when using the exit command.");
        }
        this.validateExitStatus(exitStatusKey);
    }

    private int validateExitStatus(String exitStatusKey) throws CommandExecutionException {
        int exitStatusValue = 0;
        String actualValue = null;
        try {
            if (exitStatusKey != null) {
                actualValue = (String)this.cmdArgs.get(exitStatusKey);
                exitStatusValue = Integer.parseInt(actualValue);
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Invalid integer for 'exitCode': " + actualValue, (Throwable)nfe);
        }
        return exitStatusValue;
    }

    @Override
    public void execute(CommandResultsBuilder resultsBuilder) throws CommandExecutionException {
        Scope.getCurrentScope().getLog(ExitCommandAction.class).info("Executing exit command");
        if (this.cmdArgs == null || this.cmdArgs.isEmpty()) {
            resultsBuilder.addResult("exitCode", (Object)0);
            return;
        }
        String exitStatusKey = CollectionUtil.findKeyInMapIgnoreCase((String)"exitCode", this.cmdArgs);
        String messageKey = CollectionUtil.findKeyInMapIgnoreCase((String)"exitMessage", this.cmdArgs);
        if (exitStatusKey != null) {
            int exitStatusValue = this.validateExitStatus(exitStatusKey);
            resultsBuilder.addResult("exitCode", (Object)exitStatusValue);
        } else {
            resultsBuilder.addResult("exitCode", (Object)0);
        }
        if (messageKey != null) {
            String message = (String)this.cmdArgs.get(messageKey);
            resultsBuilder.addResult("exitMessage", (Object)message);
        }
    }
}

