/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.parser;

import com.datical.liquibase.ext.parser.ProFormattedChangelogParserUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.license.LicenseServiceUtils;
import liquibase.parser.core.formattedsql.FormattedSqlChangeLogParser;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class ProFormattedSqlChangeLogParser
extends FormattedSqlChangeLogParser {
    public static final String ENCODING = "encoding";
    public static final String RELATIVE_TO_CHANGELOG = "relativeToChangelog";
    public static final String RELATIVE_TO_CHANGELOG_FILE = "relativeToChangelogFile";
    protected final String ROLLBACK_SQL_FILE_REGEX = String.format("\\s*%s[\\s]*rollbackSqlFile[\\s]+(.*)", this.getSingleLineCommentSequence());
    protected final Pattern ROLLBACK_SQL_FILE_PATTERN = Pattern.compile(this.ROLLBACK_SQL_FILE_REGEX, 2);
    protected final String TAG_DATABASE_REGEX = String.format("\\s*?%s[\\s]*?tagDatabase:[\\s]+?(.*)", this.getSingleLineCommentSequence());
    protected final Pattern TAG_DATABASE_PATTERN = Pattern.compile(this.TAG_DATABASE_REGEX, 2);
    protected final String INCLUDE_REGEX = String.format("\\s*%s[\\s]*include[\\s]+(.*)", this.getSingleLineCommentSequence());
    protected final Pattern INCLUDE_PATTERN = Pattern.compile(this.INCLUDE_REGEX, 2);
    protected final String INCLUDE_ALL_REGEX = String.format("\\s*%s[\\s]*includeAll[\\s]+(.*)", this.getSingleLineCommentSequence());
    protected final Pattern INCLUDE_ALL_PATTERN = Pattern.compile(this.INCLUDE_ALL_REGEX, 2);
    protected final String FILE_REGEX = String.format("\\s*%s[\\s]*file[\\s]+(.*)", this.getSingleLineCommentSequence());
    protected final Pattern FILE_PATTERN = Pattern.compile(this.FILE_REGEX, 2);
    protected static final String PATH_REGEX = ".*path:(\".*?\"|\\S*).*";
    protected final Pattern PATH_PATTERN = Pattern.compile(".*path:(\".*?\"|\\S*).*", 2);
    private static final String ENCODING_REGEX = ".*encoding:(\".*?\"|\\S*).*";
    private final Pattern ENCODING_PATTERN = Pattern.compile(".*encoding:(\".*?\"|\\S*).*", 2);

    public int getPriority() {
        return super.getPriority() + 5;
    }

    protected void configureChangeSet(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, BufferedReader reader, StringBuilder currentSequence, StringBuilder currentRollbackSequence, ChangeSet changeSet, int count, String line, Matcher commentMatcher, ResourceAccessor resourceAccessor, DatabaseChangeLog changeLog, AbstractSQLChange change, Matcher rollbackSplitStatementsPatternMatcher, boolean rollbackSplitStatements, String rollbackEndDelimiter, AtomicBoolean changeSetFinished) throws ChangeLogParseException, IOException {
        Matcher rollbackSqlFileMatcher = this.ROLLBACK_SQL_FILE_PATTERN.matcher(line);
        Matcher tagDatabaseMatcher = this.TAG_DATABASE_PATTERN.matcher(line);
        if (this.handleAdditionalLines(changeLog, resourceAccessor, line, currentSequence)) {
            this.handleChangeSet(physicalChangeLogLocation, changeLogParameters, changeSet, currentSequence, change, changeLog, currentRollbackSequence, rollbackSplitStatementsPatternMatcher, rollbackSplitStatements, rollbackEndDelimiter);
            ProFormattedSqlChangeLogParser.resetSequences((StringBuilder)currentSequence, (StringBuilder)currentRollbackSequence);
            changeSetFinished.set(true);
        } else if (rollbackSqlFileMatcher.matches()) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                Scope.getCurrentScope().getUI().sendMessage("ERROR: Using rollback scripts with formatted SQL requires a valid Liquibase Pro key. Get a free license key at https://liquibase.com/trial. Add liquibase.licenseKey=<yourKey> into your defaults file or use --license-key=<yourKey> before your command in the CLI.");
            } else if (resourceAccessor != null) {
                String rollbackSqlAttributes = rollbackSqlFileMatcher.group(1);
                Matcher m = this.PATH_PATTERN.matcher(rollbackSqlAttributes);
                if (!m.matches()) {
                    String message = String.format(EXCEPTION_MESSAGE, physicalChangeLogLocation, count, this.getSequenceName(), "--rollbackSqlFile path:<SQL file path> [relativeToChangelog:true|false]", this.getDocumentationLink());
                    throw new ChangeLogParseException("\n" + message);
                }
                Scope.getCurrentScope().getLog(ProFormattedSqlChangeLogParser.class).fine("Matched rollback by SQL file");
                String path = DatabaseChangeLog.normalizePath((String)m.group(1));
                boolean isRelativeToChangelog = false;
                isRelativeToChangelog = this.parseBoolean(ProFormattedChangelogParserUtil.RELATIVE_TO_CHANGELOG_PATTERN.matcher(rollbackSqlAttributes), changeSet, false, RELATIVE_TO_CHANGELOG);
                if (!isRelativeToChangelog) {
                    isRelativeToChangelog = this.parseBoolean(ProFormattedChangelogParserUtil.RELATIVE_TO_CHANGELOG_FILE_PATTERN.matcher(rollbackSqlAttributes), changeSet, false, RELATIVE_TO_CHANGELOG_FILE);
                }
                String encoding = this.handleEncoding(line);
                RawSQLChange rawSQLChange = new RawSQLChange(this.readRollbackSqlFile(path, resourceAccessor, physicalChangeLogLocation, isRelativeToChangelog, encoding));
                this.handleEndDelimiter(line, (AbstractSQLChange)rawSQLChange);
                String dbms = this.handleDbms(changeLogParameters, line, changeSet.getChangeLog());
                rawSQLChange.setDbms(dbms);
                this.handleSplitStatements(line, changeSet, (AbstractSQLChange)rawSQLChange);
                this.handleStripComments(line, changeSet, (AbstractSQLChange)rawSQLChange);
                changeSet.addRollbackChange((Change)rawSQLChange);
            }
        } else if (tagDatabaseMatcher.matches()) {
            changeSet.removeAllChanges((Collection)changeSet.getChanges());
            if (!LicenseServiceUtils.isProLicenseValid()) {
                String message = "ERROR: Using tagDatabase with formatted SQL requires a valid Liquibase Pro key. Get a free license key at https://liquibase.com/trial. Add liquibase.licenseKey=<yourKey> into your defaults file or use --license-key=<yourKey> before your command in the CLI.";
                Scope.getCurrentScope().getUI().sendMessage(message);
                changeSet.getChangeLog().getSkippedBecauseOfLicenseChangeSets().add(changeSet);
                changeSet.getChangeLog().getChangeSets().remove(changeSet);
            } else {
                Scope.getCurrentScope().getLog(ProFormattedSqlChangeLogParser.class).fine("Matched tagDatabase attribute");
                String tag = tagDatabaseMatcher.group(1);
                TagDatabaseChange tagDatabaseChange = new TagDatabaseChange();
                tagDatabaseChange.setTag(StringUtil.stripEnclosingQuotes((String)tag));
                changeSet.addChange((Change)tagDatabaseChange);
                super.configureChangeSet(physicalChangeLogLocation, changeLogParameters, reader, currentSequence, currentRollbackSequence, changeSet, count, line, commentMatcher, resourceAccessor, null, null, null, false, null, changeSetFinished);
            }
        } else {
            super.configureChangeSet(physicalChangeLogLocation, changeLogParameters, reader, currentSequence, currentRollbackSequence, changeSet, count, line, commentMatcher, resourceAccessor, null, null, null, false, null, changeSetFinished);
        }
        if (ProFormattedSqlChangeLogParser.isFirstSqlLine((StringBuilder)currentSequence, (AbstractSQLChange)change)) {
            ((RawSQLChange)change).setSqlStartLine(Integer.valueOf(count));
        }
    }

    protected boolean handleAdditionalLines(DatabaseChangeLog changeLog, ResourceAccessor resourceAccessor, String line, StringBuilder currentSequence) throws ChangeLogParseException {
        Matcher fileMatcher = this.FILE_PATTERN.matcher(line);
        boolean isFile = fileMatcher.matches();
        Matcher includeMatcher = this.INCLUDE_PATTERN.matcher(line);
        boolean include = includeMatcher.matches();
        Matcher includeAllMatcher = this.INCLUDE_ALL_PATTERN.matcher(line);
        boolean includeAll = includeAllMatcher.matches();
        if (!(include || includeAll || isFile)) {
            return false;
        }
        if (!LicenseServiceUtils.isProLicenseValid()) {
            String option = include ? "include" : (includeAll ? "includeAll" : "file");
            String message = ProFormattedSqlChangeLogParser.displayLicenseError(option);
            throw new ChangeLogParseException(message);
        }
        if (isFile) {
            return this.readFile(changeLog, resourceAccessor, line, currentSequence, fileMatcher);
        }
        if (include) {
            return ProFormattedChangelogParserUtil.handleInclude(changeLog, resourceAccessor, includeMatcher);
        }
        return ProFormattedChangelogParserUtil.handleIncludeAll(changeLog, resourceAccessor, includeAllMatcher);
    }

    private static String displayLicenseError(String option) {
        return String.format("ERROR: Using '%s' with formatted SQL requires a valid Liquibase Pro key. Get a free license key at https://liquibase.com/trial. Add liquibase.licenseKey=<yourKey> into your defaults file or use --license-key=<yourKey> before your command in the CLI.", option);
    }

    protected String readRollbackSqlFile(String path, ResourceAccessor resourceAccessor, String physicalChangelogLocation, boolean isRelativeToChangelog, String encoding) throws IOException {
        if (isRelativeToChangelog) {
            path = resourceAccessor.get(physicalChangelogLocation).resolveSibling(path).getPath();
            path = DatabaseChangeLog.normalizePath((String)Paths.get(path, new String[0]).toString());
        }
        try (InputStream inputStream = resourceAccessor.get(path).openInputStream();){
            String string = StreamUtil.readStreamAsString((InputStream)inputStream, (String)encoding);
            return string;
        }
    }

    private boolean readFile(DatabaseChangeLog changeLog, ResourceAccessor resourceAccessor, String line, StringBuilder currentSequence, Matcher fileMatcher) throws ChangeLogParseException {
        Resource resource = null;
        String pathAttributes = fileMatcher.group(1);
        Matcher pathMatcher = this.PATH_PATTERN.matcher(pathAttributes.trim());
        if (!pathMatcher.matches()) {
            throw new ChangeLogParseException(String.format("No path attribute included in '%s'", line));
        }
        String path = pathMatcher.group(1);
        boolean isRelativeToChangelog = this.parseBoolean(ProFormattedChangelogParserUtil.RELATIVE_TO_CHANGELOG_PATTERN.matcher(pathAttributes), null, false);
        try {
            resource = isRelativeToChangelog ? resourceAccessor.get(changeLog.getPhysicalFilePath()).resolveSibling(path) : resourceAccessor.getExisting(path);
        }
        catch (IOException ioe) {
            throw new ChangeLogParseException("Unable to find file '" + path + "'", (Throwable)ioe);
        }
        if (!resource.exists()) {
            throw new ChangeLogParseException(String.format("Unable to locate resource '%s'", resource.getUri().toString()));
        }
        try (InputStream stream = resource.openInputStream();){
            String encoding = this.handleEncoding(line);
            String content = StreamUtil.readStreamAsString((InputStream)stream, (String)encoding);
            currentSequence.append(content);
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        return true;
    }

    private String handleEncoding(String line) {
        Matcher encodingPatternMatcher = this.ENCODING_PATTERN.matcher(line);
        return this.parseString(encodingPatternMatcher, ENCODING);
    }
}

