/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator;

import com.datical.liquibase.ext.database.core.ProDb2zConfiguration;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.Db2zDatabase;
import liquibase.exception.CommandValidationException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.license.LicenseServiceUtils;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.CreateDatabaseChangeLogTableStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;
import org.apache.commons.lang3.StringUtils;

public class ProDb2zCreateDatabaseChangelogTableGenerator
extends AbstractSqlGenerator<CreateDatabaseChangeLogTableStatement> {
    public int getPriority() {
        return 6;
    }

    public boolean supports(CreateDatabaseChangeLogTableStatement statement, Database database) {
        return database instanceof Db2zDatabase;
    }

    public ValidationErrors validate(CreateDatabaseChangeLogTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        if (database instanceof Db2zDatabase && LicenseServiceUtils.isProLicenseValid()) {
            validationErrors.addAll(ProDb2zConfiguration.validateTrackingTablesLocationConsistency());
        }
        return validationErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sql[] generateSql(CreateDatabaseChangeLogTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors;
        boolean usingDb2zProperties;
        String dbName = (String)ProDb2zConfiguration.CHANGELOG_TABLES_DATABASE.getCurrentValue();
        String tsName = (String)ProDb2zConfiguration.CHANGELOG_TABLES_TABLESPACE.getCurrentValue();
        String idxName = (String)ProDb2zConfiguration.DATABASECHANGELOG_INDEX.getCurrentValue();
        boolean bl = usingDb2zProperties = StringUtils.isNotEmpty((CharSequence)dbName) || StringUtils.isNotEmpty((CharSequence)tsName) || StringUtils.isNotEmpty((CharSequence)idxName);
        if (usingDb2zProperties) {
            try {
                ProDb2zConfiguration.checkProLicenseForDb2zFeatures();
            }
            catch (CommandValidationException e) {
                String errorMessage = "Using DB2z tracking table customization properties requires a valid Liquibase Pro license. Get a free license key at https://liquibase.com/trial. Add liquibase.licenseKey=<yourKey> into your defaults file or use --license-key=<yourKey> before your command in the CLI.";
                throw new UnexpectedLiquibaseException(errorMessage);
            }
        }
        if ((validationErrors = ProDb2zConfiguration.validateTrackingTablesLocationConsistency()).hasErrors()) {
            throw new RuntimeException("DB2z tracking tables configuration error: " + (String)validationErrors.getErrorMessages().get(0));
        }
        ObjectQuotingStrategy currentStrategy = database.getObjectQuotingStrategy();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        try {
            String catalog = database.getLiquibaseCatalogName();
            String schema = database.getLiquibaseSchemaName();
            String tableName = database.escapeTableName(catalog, schema, database.getDatabaseChangeLogTableName());
            dbName = ProDb2zConfiguration.validateLicenseForProperty((String)ProDb2zConfiguration.CHANGELOG_TABLES_DATABASE.getCurrentValue(), ProDb2zConfiguration.CHANGELOG_TABLES_DATABASE.getKey());
            tsName = ProDb2zConfiguration.validateLicenseForProperty((String)ProDb2zConfiguration.CHANGELOG_TABLES_TABLESPACE.getCurrentValue(), ProDb2zConfiguration.CHANGELOG_TABLES_TABLESPACE.getKey());
            boolean hasDb = StringUtils.isNotEmpty((CharSequence)dbName);
            boolean hasTs = StringUtils.isNotEmpty((CharSequence)tsName);
            String createTable = String.format("CREATE TABLE %s (ID VARCHAR(255) NOT NULL, AUTHOR VARCHAR(255) NOT NULL, FILENAME VARCHAR(255) NOT NULL, DATEEXECUTED TIMESTAMP NOT NULL, ORDEREXECUTED INTEGER NOT NULL, EXECTYPE VARCHAR(10) NOT NULL, MD5SUM VARCHAR(35), DESCRIPTION VARCHAR(255), COMMENTS VARCHAR(255), TAG VARCHAR(255), LIQUIBASE VARCHAR(20), CONTEXTS VARCHAR(255), LABELS VARCHAR(255), DEPLOYMENT_ID VARCHAR(10), PRIMARY KEY(ID, AUTHOR, FILENAME))", tableName);
            if (hasDb && hasTs) {
                createTable = createTable + String.format(" IN %s.%s", dbName, tsName);
            } else if (hasTs) {
                createTable = createTable + String.format(" IN %s", tsName);
            } else if (hasDb) {
                createTable = createTable + String.format(" IN %s", dbName);
            }
            UnparsedSql createTableSql = new UnparsedSql(createTable, new DatabaseObject[]{this.getAffectedTable(database)});
            if (hasDb && hasTs) {
                idxName = ProDb2zConfiguration.validateLicenseForProperty((String)ProDb2zConfiguration.DATABASECHANGELOG_INDEX.getCurrentValue(), ProDb2zConfiguration.DATABASECHANGELOG_INDEX.getKey());
                if (StringUtils.isEmpty((CharSequence)idxName)) {
                    idxName = database.getDatabaseChangeLogTableName() + "_PK";
                }
                String qualifiedIdxName = database.escapeObjectName(idxName, Table.class);
                String createIndex = String.format("CREATE UNIQUE INDEX %s ON %s%s (ID, AUTHOR, FILENAME)", qualifiedIdxName, schema != null && !schema.isEmpty() ? schema + "." : "", database.getDatabaseChangeLogTableName());
                UnparsedSql createIndexSql = new UnparsedSql(createIndex, new DatabaseObject[]{this.getAffectedTable(database)});
                Sql[] sqlArray = new Sql[]{createTableSql, createIndexSql};
                return sqlArray;
            }
            Sql[] sqlArray = new Sql[]{createTableSql};
            return sqlArray;
        }
        finally {
            database.setObjectQuotingStrategy(currentStrategy);
        }
    }

    protected Relation getAffectedTable(Database database) {
        return new Table().setName(database.getDatabaseChangeLogTableName()).setSchema(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName());
    }
}

