/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator.compositetype;

import com.datical.liquibase.ext.appdba.type.CompositeType;
import com.datical.liquibase.ext.statement.compositetype.RenameCompositeTypeAttributeStatement;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class RenameCompositeTypeAttributeGenerator
extends AbstractSqlGenerator<RenameCompositeTypeAttributeStatement> {
    public boolean supports(RenameCompositeTypeAttributeStatement statement, Database database) {
        return database instanceof PostgresDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(RenameCompositeTypeAttributeStatement statement, Database database, SqlGeneratorChain<RenameCompositeTypeAttributeStatement> sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("typeName", (Object)statement.getTypeName());
        validationErrors.checkRequiredField("oldAttributeName", (Object)statement.getOldAttributeName());
        validationErrors.checkRequiredField("newAttributeName", (Object)statement.getNewAttributeName());
        return validationErrors;
    }

    public Sql[] generateSql(RenameCompositeTypeAttributeStatement statement, Database database, SqlGeneratorChain<RenameCompositeTypeAttributeStatement> sqlGeneratorChain) {
        String sql = String.format("ALTER TYPE %s RENAME ATTRIBUTE %s TO %s%s", database.escapeObjectName(statement.getCatalogName(), statement.getSchemaName(), statement.getTypeName(), CompositeType.class), database.escapeObjectName(statement.getOldAttributeName(), DatabaseObject.class), database.escapeObjectName(statement.getNewAttributeName(), DatabaseObject.class), statement.getOnUpdate() != null ? " " + statement.getOnUpdate() : "");
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[0])};
    }
}

