/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint;

import com.datical.liquibase.ext.license.LicenseCheckingSnapshotGenerator;
import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraint;
import com.datical.liquibase.ext.storedlogic.checkconstraint.postgres.PostgresCheckConstraintSnapshotGenerator;
import com.datical.liquibase.ext.util.CachedQueryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawParameterizedSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.JdbcUtil;
import liquibase.util.StringUtil;

public class CheckConstraintSnapshotGenerator
extends LicenseCheckingSnapshotGenerator {
    private boolean foundAllCheckConstraints = false;

    public CheckConstraintSnapshotGenerator() {
        super(CheckConstraint.class, new Class[]{Schema.class, Table.class});
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase && ((MySQLDatabase)database).isMinimumMySQLVersion("8.0.16") || database instanceof AbstractDb2Database || database instanceof PostgresDatabase && !database.getShortName().equalsIgnoreCase("redshift")) {
            return super.getPriority(objectType, database);
        }
        return -1;
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        if (this.foundAllCheckConstraints) {
            return example;
        }
        Database database = snapshot.getDatabase();
        CheckConstraint exampleConstraint = (CheckConstraint)example;
        Table table = exampleConstraint.getTable();
        String sql = this.getSnapshotObjectSql(example, database, table);
        List rows = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", snapshot.getDatabase()).queryForList((SqlStatement)new RawParameterizedSqlStatement(sql));
        if (rows.size() == 0) {
            return null;
        }
        try {
            JdbcUtil.requiredSingleResult((Collection)rows);
        }
        catch (DatabaseException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Error snapshotting " + example + " with result set of " + sql, (Throwable)e);
            throw e;
        }
        Map metadata = (Map)rows.get(0);
        CheckConstraint constraint = this.mapBaseResultSetToCheckConstraint(database, metadata);
        constraint.setTable(table);
        return constraint;
    }

    protected String getSnapshotObjectSql(DatabaseObject example, Database database, Table table) {
        String sql;
        if (database instanceof PostgresDatabase) {
            return new PostgresCheckConstraintSnapshotGenerator().getSnapshotObjectSql(example, database, table);
        }
        if (database instanceof OracleDatabase) {
            sql = "SELECT OWNER, CONSTRAINT_NAME, TABLE_NAME, SEARCH_CONDITION, STATUS, VALIDATED FROM all_constraints  WHERE constraint_type = 'C'";
            if (example.getName() != null) {
                sql = sql + " and constraint_name='" + example.getName() + "'";
            }
            if (((CheckConstraint)example).getTable() != null) {
                sql = sql + " and table_name='" + ((CheckConstraint)example).getTable().getName() + "'";
                if (((CheckConstraint)example).getTable().getSchema() != null && ((CheckConstraint)example).getTable().getSchema().getCatalogName() != null) {
                    sql = sql + " and owner='" + ((CheckConstraint)example).getTable().getSchema().getCatalogName() + "'";
                }
            }
        } else if (database instanceof DB2Database) {
            sql = "SELECT CHECKS.CONSTNAME AS CONSTRAINT_NAME, CHECKS.TEXT AS SEARCH_CONDITION, TABCONST.ENFORCED AS ENFORCED, CHECKS.TABNAME AS TABLE_NAME FROM SYSCAT.CHECKS CHECKS INNER JOIN SYSCAT.TABCONST TABCONST ON TABCONST.CONSTNAME=CHECKS.CONSTNAME AND TABCONST.TABSCHEMA=CHECKS.TABSCHEMA AND TABCONST.TABNAME=CHECKS.TABNAME WHERE CHECKS.TYPE != 'S' AND CHECKS.TABSCHEMA='" + ((CheckConstraint)example).getTable().getSchema().getCatalogName() + "' AND CHECKS.TABNAME='" + ((CheckConstraint)example).getTable().getName() + "'AND CHECKS.CONSTNAME='" + example.getName() + "'";
        } else if (database instanceof Db2zDatabase) {
            sql = "SELECT CHECKNAME AS CONSTRAINT_NAME, CHECKCONDITION AS SEARCH_CONDITION, 'Y' AS ENFORCED, TBNAME AS TABLE_NAME FROM SYSIBM.SYSCHECKS WHERE TBOWNER='" + ((CheckConstraint)example).getTable().getSchema().getCatalogName() + "' AND TBNAME='" + ((CheckConstraint)example).getTable().getName() + "'AND CHECKNAME='" + example.getName() + "'";
        } else if (database instanceof MySQLDatabase) {
            sql = "select TABLE_SCHEMA, TABLE_NAME, CONSTRAINT_NAME from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where CONSTRAINT_TYPE = 'CHECK' and TABLE_SCHEMA = '" + ((CheckConstraint)example).getTable().getSchema().getName() + "'and TABLE_NAME = '" + ((CheckConstraint)example).getTable().getName() + "'";
        } else if (database instanceof MSSQLDatabase) {
            String schemaName = example.getSchema() == null ? "dbo" : example.getSchema().getName();
            sql = "SELECT  sys.objects.name AS CONSTRAINT_NAME, syscomments.text AS SEARCH_CONDITION, IS_DISABLED as IS_DISABLED FROM sys.objects INNER JOIN sys.schemas ON sys.objects.schema_id = sys.schemas.schema_id and lower(sys.schemas.name)='" + schemaName + "' INNER JOIN syscomments ON syscomments.id = sys.objects.object_id INNER JOIN sys.objects parent on objects.parent_object_id=parent.object_id and parent.name='" + table.getName() + "' and parent.type_desc='USER_TABLE' INNER JOIN sys.check_constraints ON check_constraints.object_id = sys.objects.object_id where objects.type_desc='CHECK_CONSTRAINT' and sys.objects.name='" + example.getName() + "'";
        } else {
            throw new UnexpectedLiquibaseException("Unsupported database for check constraint snapshot" + database.getShortName());
        }
        return sql;
    }

    private CheckConstraint mapBaseResultSetToCheckConstraint(Database database, Map<String, ?> metadata) {
        CheckConstraint checkConstraint = new CheckConstraint();
        checkConstraint.setName((String)metadata.get("CONSTRAINT_NAME"));
        checkConstraint.setBody(StringUtil.trimToNull((String)((String)metadata.get("SEARCH_CONDITION"))));
        if (database instanceof PostgresDatabase) {
            checkConstraint.setDisabled(!metadata.get("STATUS").equals("ENABLED"));
        } else if (database instanceof OracleDatabase) {
            checkConstraint.setDisabled(!metadata.get("STATUS").equals("ENABLED"));
            checkConstraint.setValidate("VALIDATED".equalsIgnoreCase(metadata.get("VALIDATED").toString()));
        } else if (database instanceof MySQLDatabase) {
            String enforcedValue = (String)metadata.get("ENFORCED");
            if (enforcedValue != null && enforcedValue.toUpperCase().equals("NOT ENFORCED")) {
                checkConstraint.setDisabled(true);
            } else {
                checkConstraint.setDisabled(false);
            }
        } else if (database instanceof AbstractDb2Database) {
            checkConstraint.setDisabled(!metadata.get("ENFORCED").equals("Y"));
        } else if (database instanceof MSSQLDatabase) {
            checkConstraint.setDisabled((Boolean)metadata.get("IS_DISABLED"));
        } else {
            throw new UnexpectedLiquibaseException("Unknown database type for check constraint snapshot: " + database.getShortName());
        }
        return checkConstraint;
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException {
        if (!snapshot.getSnapshotControl().shouldInclude(CheckConstraint.class)) {
            return;
        }
        Database database = snapshot.getDatabase();
        if (foundObject instanceof Table) {
            Table table = (Table)foundObject;
            if (this.foundAllCheckConstraints) {
                this.addConstraintsToTable(foundObject, snapshot, database, table);
            } else {
                String sql = this.getAddToSql(database, table);
                List rows = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", snapshot.getDatabase()).queryForList((SqlStatement)new RawParameterizedSqlStatement(sql));
                for (Map row : rows) {
                    CheckConstraint constraint = new CheckConstraint().setName(this.cleanNameFromDatabase((String)row.get("CONSTRAINT_NAME"), database)).setTable(table).setBody((String)row.get("SEARCH_CONDITION"));
                    ArrayList<CheckConstraint> checkConstraints = (ArrayList<CheckConstraint>)table.getAttribute("checkConstraints", List.class);
                    if (!this.isSystemConstraint(constraint)) continue;
                    if (checkConstraints == null) {
                        checkConstraints = new ArrayList<CheckConstraint>();
                        table.setAttribute("checkConstraints", checkConstraints);
                    }
                    checkConstraints.add(constraint);
                }
            }
            List checkConstraints = (List)table.getAttribute("checkConstraints", List.class);
            if (checkConstraints != null) {
                this.sortCheckConstraints(checkConstraints);
            }
        } else if (foundObject instanceof Schema) {
            SqlExt sqlExt = this.getAddToSqlForSchema(foundObject, snapshot, database);
            List<Map<String, ?>> rows = CachedQueryUtil.queryIfNotCached(sqlExt.isFetchedAcrossSchemas(), sqlExt.getSql(), "CheckConstraintSnapshotGenerator.allConstraints", snapshot);
            for (Map<String, ?> metadata : rows) {
                String tableSchemaName;
                String tableCatalogName;
                CheckConstraint constraint = this.mapBaseResultSetToCheckConstraint(database, metadata);
                if (database instanceof OracleDatabase) {
                    tableCatalogName = (String)metadata.get("OWNER");
                    tableSchemaName = (String)metadata.get("OWNER");
                } else {
                    tableCatalogName = StringUtil.trimToNull((String)((Schema)foundObject).getCatalogName());
                    tableSchemaName = StringUtil.trimToNull(foundObject.getSchema() == null ? null : foundObject.getSchema().getName());
                }
                String tableNameStr = StringUtil.trimToNull((String)metadata.get("TABLE_NAME").toString());
                String tableName = this.cleanNameFromDatabase(tableNameStr, database);
                constraint.setTable(new Table(tableCatalogName, tableSchemaName, tableName));
                if (sqlExt.isFetchedAcrossSchemas() && !tableCatalogName.equals(foundObject.getName()) || !this.isSystemConstraint(constraint)) continue;
                ((Schema)foundObject).addDatabaseObject((DatabaseObject)constraint);
            }
            this.foundAllCheckConstraints = true;
        }
    }

    private void addConstraintsToTable(DatabaseObject foundObject, DatabaseSnapshot snapshot, Database database, Table table) {
        Schema schema = (Schema)snapshot.get((DatabaseObject)foundObject.getSchema());
        if (schema != null) {
            for (CheckConstraint constraint : schema.getDatabaseObjects(CheckConstraint.class)) {
                if (!DatabaseObjectComparatorFactory.getInstance().isSameObject((DatabaseObject)constraint.getTable(), foundObject, null, database)) continue;
                ArrayList<CheckConstraint> checkConstraints = (ArrayList<CheckConstraint>)table.getAttribute("checkConstraints", List.class);
                if (checkConstraints == null) {
                    checkConstraints = new ArrayList<CheckConstraint>();
                    table.setAttribute("checkConstraints", checkConstraints);
                }
                checkConstraints.add(constraint);
                this.sortCheckConstraints(checkConstraints);
            }
        }
    }

    protected SqlExt getAddToSqlForSchema(DatabaseObject foundObject, DatabaseSnapshot databaseSnapshot, Database database) throws DatabaseException {
        String sql;
        boolean fetchedAcrossSchemas = false;
        if (database instanceof PostgresDatabase) {
            return new PostgresCheckConstraintSnapshotGenerator().getAddToSqlForSchema(foundObject, databaseSnapshot, database);
        }
        if (database instanceof OracleDatabase) {
            String allCatalogs;
            sql = "SELECT OWNER, CONSTRAINT_NAME, TABLE_NAME, SEARCH_CONDITION, STATUS, VALIDATED FROM all_constraints  WHERE constraint_type = 'C' AND SEARCH_CONDITION IS NOT NULL ";
            if (database.getDatabaseMajorVersion() > 11) {
                sql = sql + "AND NOT(REGEXP_LIKE(SEARCH_CONDITION_VC, '^\"\\w+\" IS NOT NULL$')) ";
            }
            if ((allCatalogs = (String)databaseSnapshot.getScratchData("DatabaseSnapshot.allCatalogsString")) == null) {
                sql = sql + " and owner='" + ((Schema)foundObject).getCatalogName() + "'";
            } else {
                sql = sql + " and owner IN ('" + ((Schema)foundObject).getCatalogName() + "', " + allCatalogs + ")";
                fetchedAcrossSchemas = true;
            }
        } else if (database instanceof DB2Database) {
            sql = "SELECT CHECKS.CONSTNAME AS CONSTRAINT_NAME, CHECKS.TEXT AS SEARCH_CONDITION, TABCONST.ENFORCED AS ENFORCED, CHECKS.TABNAME AS TABLE_NAME FROM SYSCAT.CHECKS CHECKS INNER JOIN SYSCAT.TABCONST TABCONST ON TABCONST.CONSTNAME=CHECKS.CONSTNAME AND TABCONST.TABSCHEMA=CHECKS.TABSCHEMA AND TABCONST.TABNAME=CHECKS.TABNAME AND CHECKS.TYPE != 'S' WHERE CHECKS.TABSCHEMA='" + ((Schema)foundObject).getCatalogName() + "'AND CHECKS.CONSTNAME != 'RCT' AND CHECKS.CONSTNAME != 'RCT_OFLOW'";
        } else if (database instanceof Db2zDatabase) {
            sql = "SELECT CHECKNAME AS CONSTRAINT_NAME, CHECKCONDITION AS SEARCH_CONDITION, 'Y' AS ENFORCED, TBNAME AS TABLE_NAME FROM SYSIBM.SYSCHECKS WHERE TBOWNER='" + ((Schema)foundObject).getCatalogName() + "'";
        } else if (database instanceof MySQLDatabase) {
            sql = "select tc.TABLE_SCHEMA, tc.TABLE_NAME, tc.CONSTRAINT_NAME, cc.CHECK_CLAUSE AS SEARCH_CONDITION from INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc inner join INFORMATION_SCHEMA.CHECK_CONSTRAINTS cc ON tc.CONSTRAINT_NAME = cc.CONSTRAINT_NAME AND tc.CONSTRAINT_SCHEMA = cc.CONSTRAINT_SCHEMA AND tc.CONSTRAINT_CATALOG = cc.CONSTRAINT_CATALOG where CONSTRAINT_TYPE = 'CHECK' and TABLE_SCHEMA = '" + ((Schema)foundObject).getName() + "'";
        } else if (database instanceof MSSQLDatabase) {
            String schemaName = foundObject.getName() == null ? "dbo" : foundObject.getName().toLowerCase();
            sql = "SELECT  sys.objects.name AS CONSTRAINT_NAME, parent.name as TABLE_NAME, syscomments.text AS SEARCH_CONDITION, IS_DISABLED as IS_DISABLED FROM sys.objects INNER JOIN sys.schemas ON sys.objects.schema_id = sys.schemas.schema_id and lower(sys.schemas.name)='" + schemaName + "' INNER JOIN syscomments ON syscomments.id = sys.objects.object_id INNER JOIN sys.objects parent on objects.parent_object_id=parent.object_id and parent.type_desc='USER_TABLE' INNER JOIN sys.check_constraints ON check_constraints.object_id = sys.objects.object_id where objects.type_desc='CHECK_CONSTRAINT'";
        } else {
            throw new UnexpectedLiquibaseException("Unsupported database for check constraint snapshot" + database.getShortName());
        }
        return new SqlExt(sql, fetchedAcrossSchemas);
    }

    protected String getAddToSql(Database database, Table table) {
        String sql;
        if (database instanceof PostgresDatabase) {
            return new PostgresCheckConstraintSnapshotGenerator().getAddToSql(database, table);
        }
        if (database instanceof OracleDatabase) {
            sql = "SELECT OWNER, CONSTRAINT_NAME, TABLE_NAME, SEARCH_CONDITION, STATUS, VALIDATED FROM all_constraints  WHERE constraint_type = 'C' and table_name='" + table.getName() + "'";
            if (table.getSchema() != null) {
                sql = sql + " and owner='" + table.getSchema().getCatalogName() + "'";
            }
        } else if (database instanceof DB2Database) {
            sql = "SELECT CONSTNAME AS CONSTRAINT_NAME FROM SYSCAT.CHECKS WHERE TABSCHEMA='" + table.getSchema().getCatalogName() + "' AND TYPE != 'S' AND TABNAME='" + table.getName() + "'";
        } else if (database instanceof Db2zDatabase) {
            sql = "SELECT CHECKNAME AS CONSTRAINT_NAME FROM SYSIBM.SYSCHECKS WHERE TBOWNER='" + table.getSchema().getCatalogName() + "' AND TBNAME='" + table.getName() + "'";
        } else if (database instanceof MySQLDatabase) {
            sql = "select CONSTRAINT_NAME from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where CONSTRAINT_TYPE = 'CHECK' and TABLE_SCHEMA = '" + table.getSchema().getName() + "'and TABLE_NAME = '" + table.getName() + "'";
        } else if (database instanceof MSSQLDatabase) {
            Schema schema = table.getSchema();
            sql = "SELECT  sys.objects.name AS CONSTRAINT_NAME FROM sys.objects INNER JOIN sys.schemas ON sys.objects.schema_id = sys.schemas.schema_id and sys.schemas.name='" + ((MSSQLDatabase)database).getJdbcSchemaName(schema.toCatalogAndSchema()) + "' INNER JOIN sys.objects parent on objects.parent_object_id=parent.object_id and parent.name='" + table.getName() + "' and parent.type_desc='USER_TABLE' where objects.type_desc='CHECK_CONSTRAINT'";
        } else {
            throw new UnexpectedLiquibaseException("Unsupported database for check constraint snapshot: " + database.getShortName());
        }
        return sql;
    }

    private void sortCheckConstraints(List<CheckConstraint> checkConstraints) {
        checkConstraints.sort(new Comparator<CheckConstraint>(){

            @Override
            public int compare(CheckConstraint o1, CheckConstraint o2) {
                int i = StringUtil.trimToEmpty((String)o1.getName()).compareTo(StringUtil.trimToEmpty((String)o2.getName()));
                if (i == 0) {
                    return o1.toString().compareTo(o2.toString());
                }
                return i;
            }
        });
    }

    private boolean isSystemConstraint(CheckConstraint constraint) {
        String body = constraint.getBody();
        if (body == null) {
            return true;
        }
        return !body.matches("\"?\\w+\" IS NOT NULL");
    }

    protected class SqlExt {
        private String sql;
        private boolean fetchedAcrossSchemas;

        SqlExt(String sql, boolean fetchedAcrossSchemas) {
            this.sql = sql;
            this.fetchedAcrossSchemas = fetchedAcrossSchemas;
        }

        public SqlExt(String sql) {
            this.sql = sql;
            this.fetchedAcrossSchemas = false;
        }

        String getSql() {
            return this.sql;
        }

        boolean isFetchedAcrossSchemas() {
            return this.fetchedAcrossSchemas;
        }
    }
}

