/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.tools.AbstractNativeToolExecutor;
import com.datical.liquibase.ext.tools.SqlcmdRunner;
import java.util.List;
import liquibase.Scope;
import liquibase.exception.DatabaseException;
import liquibase.logging.Logger;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;

public class MssqlSqlcmdExecutor
extends AbstractNativeToolExecutor {
    public MssqlSqlcmdExecutor() {
        super("sqlcmd");
    }

    public String getName() {
        return "sqlcmd";
    }

    public int getPriority() {
        return 101;
    }

    public void execute(SqlStatement action, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        log.info("Executing with the '" + this.getName() + "' executor");
        Sql[] sqls = SqlGeneratorFactory.getInstance().generateSql(action, this.database);
        try {
            SqlcmdRunner runner = new SqlcmdRunner(this.changeSet, null);
            runner.addArg("-?");
            runner.executeCommand(this.database);
            log.info("Successfully validated 'sqlcmd'");
            runner = new SqlcmdRunner(this.changeSet, sqls);
            runner.executeCommand(this.database);
            String successMessage = String.format("%nSuccess!  Changeset '%s' by '%s' deployed by 'sqlcmd'", this.changeSet.getId(), this.changeSet.getAuthor());
            log.info(successMessage);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            String errorMessage = String.format("%nChangeset '%s' by '%s' failed to deploy with 'sqlcmd'. Please check sqlcmd logs or use the --log-level flag for more information.", this.changeSet.getId(), this.changeSet.getAuthor());
            log.warning(errorMessage);
            throw new DatabaseException((Throwable)e);
        }
    }
}

