/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools.jcl;

import com.datical.liquibase.ext.tools.NativeExecutorRunner;
import com.datical.liquibase.ext.tools.jcl.JclJob;
import com.datical.liquibase.ext.tools.jcl.JclJobOutput;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;

public class JclJobWorker
extends NativeExecutorRunner {
    public static final String RETURN_CODE = "RETURN_CODE";
    public static final String MSG = "MSG";
    public static final String JOB_ID = "JOB_ID";
    public static final String ROWNUM = "ROWNUM";
    public static final String TEXT = "TEXT";
    public static final String STMT = "STMT";
    public static final int JOB_ERROR = 12;
    private final Connection connection;

    public Connection getConnection() {
        return this.connection;
    }

    public JclJobWorker(Database database) {
        DatabaseConnection databaseConnection = database.getConnection();
        this.connection = ((JdbcConnection)databaseConnection).getWrappedConnection();
    }

    /*
     * Exception decompiling
     */
    public JclJob submit(Iterable<String> linesJCL, String username, String password) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JclJob submitJob(Iterable<String> linesJCL, String username, String password, PreparedStatement insertStatement, CallableStatement callStatement) throws SQLException {
        String jobName = null;
        int lineNumber = 1;
        for (String lineJCL : linesJCL) {
            if (jobName == null) {
                String[] parts = lineJCL.split(" ");
                if (!parts[0].startsWith("//")) {
                    throw new RuntimeException("Invalid JCL job card '" + lineJCL + "'");
                }
                jobName = parts[0].replace("//", "");
            }
            insertStatement.setInt(1, lineNumber);
            insertStatement.setString(2, lineJCL);
            ++lineNumber;
            int numRows = insertStatement.executeUpdate();
            if (numRows != 0) continue;
            throw new RuntimeException("Unable to insert JCL statement '" + lineJCL + "' in SYSIBM.JOB_JCL");
        }
        callStatement.setString(1, username);
        callStatement.setString(2, password);
        callStatement.registerOutParameter(3, 1);
        callStatement.registerOutParameter(4, 4);
        callStatement.registerOutParameter(5, 12);
        callStatement.executeUpdate();
        int returnCode = callStatement.getInt(RETURN_CODE);
        String returnMessage = callStatement.getString(MSG);
        if (returnCode == 12) {
            throw new RuntimeException(returnMessage);
        }
        String jobID = callStatement.getString(JOB_ID);
        return new JclJob(this, jobID, jobName);
    }

    public List<JclJobOutput> retrieveOutput(String id, String username, String password) throws Exception {
        ArrayList<JclJobOutput> jobOutput = new ArrayList<JclJobOutput>();
        try (CallableStatement callStatement = this.connection.prepareCall("CALL SYSPROC.ADMIN_JOB_FETCH (?, ?, ?, ?, ?)");){
            callStatement.setString(1, username);
            callStatement.setString(2, password);
            callStatement.setString(3, id);
            callStatement.registerOutParameter(4, 4);
            callStatement.registerOutParameter(5, 12);
            ResultSet resultSet = callStatement.executeQuery();
            int returnCode = callStatement.getInt(RETURN_CODE);
            String returnMessage = callStatement.getString(MSG);
            if (returnCode == 12) {
                throw new Exception(returnMessage);
            }
            while (resultSet.next()) {
                int rowNum = resultSet.getInt(ROWNUM);
                String text = resultSet.getString(TEXT);
                JclJobOutput jclJobOutput = new JclJobOutput(rowNum, text);
                jobOutput.add(jclJobOutput);
            }
        }
        return jobOutput;
    }

    @Override
    public String getIntegrationDisplayName() {
        return "jcl";
    }
}

