/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.util;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import liquibase.Scope;
import liquibase.diff.output.DiffOutputControl;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.parser.LiquibaseSqlParser;
import liquibase.parser.SqlParserFactory;
import liquibase.resource.OpenOptions;
import liquibase.resource.Resource;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.util.MD5Util;
import liquibase.util.StringClauses;
import liquibase.util.StringUtil;

public class ObjectSqlFileUtil {
    public static String writeObjectSql(StoredDatabaseLogic object) {
        return ObjectSqlFileUtil.writeObjectSql((DatabaseObject)object, object.getBody());
    }

    public static String writeObjectSql(DatabaseObject object, String sqlText) {
        return ObjectSqlFileUtil.writeObjectSql(object, sqlText, null);
    }

    public static String writeObjectSql(DatabaseObject object, String sqlText, String relativePath) {
        Resource baseDir;
        Resource saveFile;
        String objectType = object.getClass().getSimpleName().toLowerCase();
        String objectName = object.getName();
        String actualRelativePath = relativePath;
        if (relativePath == null) {
            String functionArguments;
            actualRelativePath = objectType + "/" + objectName + ".sql";
            if (objectName != null && objectName.contains("(") && (functionArguments = objectName.replaceFirst(".+?\\s*(\\(.*\\)).*", "$1")).length() > 0) {
                actualRelativePath = actualRelativePath.replace(functionArguments, "-" + MD5Util.computeMD5((String)functionArguments).substring(0, 8));
            }
        }
        if (object.getObjectTypeName().equalsIgnoreCase(Trigger.class.getSimpleName()) && objectName != null) {
            String body = (String)object.getAttribute("body", String.class);
            String suffix = body != null ? MD5Util.computeMD5((String)body).substring(0, 8) : StringUtil.randomIdentifer((int)8);
            actualRelativePath = actualRelativePath.replace(objectName, String.format("%s-%s", objectName, suffix));
        }
        DiffOutputControl diffOutputControl = (DiffOutputControl)Scope.getCurrentScope().get("diffOutputControl", DiffOutputControl.class);
        if (object.getSchema() != null) {
            if (diffOutputControl.getIncludeCatalog() && diffOutputControl.getIncludeSchema()) {
                actualRelativePath = object.getSchema().getCatalogName() + "." + object.getSchema().getName() + "/" + actualRelativePath;
            } else if (diffOutputControl.getIncludeCatalog() && object.getSchema().getCatalogName() != null) {
                actualRelativePath = object.getSchema().getCatalogName() + "/" + actualRelativePath;
            } else if (diffOutputControl.getIncludeSchema() && object.getSchema().getName() != null) {
                actualRelativePath = object.getSchema().getName() + "/" + actualRelativePath;
            }
        }
        if ((saveFile = (baseDir = (Resource)Scope.getCurrentScope().get("DiffToChangeLog.externalFilesDir", Resource.class)).resolve(actualRelativePath)).exists()) {
            throw new UnexpectedLiquibaseException(saveFile.getUri() + " already exists");
        }
        try (OutputStream outputStream = saveFile.openOutputStream(new OpenOptions());
             OutputStreamWriter osw = new OutputStreamWriter(outputStream);){
            osw.write(sqlText);
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        return new File(baseDir.getPath()).getName() + "/" + actualRelativePath;
    }

    public static String findStoredLogicName(String body, String matchAfter) {
        SqlParserFactory sqlParserFactory = (SqlParserFactory)Scope.getCurrentScope().getSingleton(SqlParserFactory.class);
        LiquibaseSqlParser sqlParser = sqlParserFactory.getSqlParser();
        StringClauses parsedSql = sqlParser.parse(body);
        StringClauses.ClauseIterator clauseIterator = parsedSql.getClauseIterator();
        Object next = clauseIterator.nextNonWhitespace();
        while (next != null && !next.toString().equalsIgnoreCase(matchAfter) && clauseIterator.hasNext()) {
            next = clauseIterator.nextNonWhitespace();
        }
        if (!clauseIterator.hasNext()) {
            return null;
        }
        String name = null;
        String candidate = clauseIterator.next().toString().replaceAll("\"", "");
        String[] parts = candidate.split("\\.");
        if (parts.length == 1) {
            name = parts[0];
        } else if (parts.length == 2) {
            name = parts[1];
        } else if (parts.length == 3) {
            name = parts[2];
        }
        if (name == null) {
            return null;
        }
        name = name.replaceAll("\\[", "");
        name = name.replaceAll("\\]", "");
        return name;
    }

    public static String findSchemaName(String body, String matchAfter) {
        SqlParserFactory sqlParserFactory = (SqlParserFactory)Scope.getCurrentScope().getSingleton(SqlParserFactory.class);
        LiquibaseSqlParser sqlParser = sqlParserFactory.getSqlParser();
        StringClauses parsedSql = sqlParser.parse(body, false, false);
        StringClauses.ClauseIterator clauseIterator = parsedSql.getClauseIterator();
        Object next = clauseIterator.nextNonWhitespace();
        while (next != null && !next.toString().equalsIgnoreCase(matchAfter) && clauseIterator.hasNext()) {
            next = clauseIterator.nextNonWhitespace();
        }
        String schemaName = null;
        String candidate = clauseIterator.next().toString().replaceAll("\"", "");
        String[] parts = candidate.split("\\.");
        if (parts.length == 2) {
            schemaName = parts[0];
        } else if (parts.length == 3) {
            schemaName = parts[1];
        }
        if (schemaName == null) {
            return null;
        }
        schemaName = schemaName.replaceAll("\\[", "");
        schemaName = schemaName.replaceAll("\\]", "");
        return schemaName;
    }
}

