/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.util;

import com.datical.liquibase.ext.util.ProConfigurationUtil;
import com.datical.liquibase.ext.util.guava.PercentEscaper;
import java.net.URI;
import java.util.ArrayList;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;

public class ProStringUtil
extends StringUtil {
    public static String markWithPro(String value) {
        if (value == null) {
            return null;
        }
        if (ProConfigurationUtil.isProDistribution()) {
            return value;
        }
        return String.format("[PRO]%s%s", System.lineSeparator(), value);
    }

    public static String wrapStringCharacterWise(String input, int breakPoint, String breakString) {
        String newLineCharacter = "\n";
        String replace = input.replace("%n", newLineCharacter);
        int index = 0;
        int maxLength = breakPoint - breakString.length();
        ArrayList<String> lines = new ArrayList<String>();
        while (index < replace.length()) {
            String maxLineChunk = replace.substring(index, Math.min(index + maxLength, replace.length()));
            int endOfLine = maxLineChunk.lastIndexOf(" ");
            int lineBreak = maxLineChunk.indexOf(newLineCharacter);
            if (lineBreak != -1) {
                lines.add(maxLineChunk.substring(0, lineBreak).trim());
                index += lineBreak + newLineCharacter.length();
                continue;
            }
            if (endOfLine != -1) {
                if (maxLineChunk.length() < maxLength) {
                    lines.add(maxLineChunk.trim());
                    index += maxLineChunk.length();
                    continue;
                }
                lines.add(maxLineChunk.substring(0, endOfLine));
                index += endOfLine;
                continue;
            }
            lines.add(maxLineChunk.trim());
            index += maxLineChunk.length();
        }
        return String.join((CharSequence)breakString, lines);
    }

    public static String stripUriPrefix(URI uri) {
        return uri.toString().replace("file://", "");
    }

    public static String buildCLICommandName(String commandName) {
        if (commandName.toLowerCase().contains("checks")) {
            return commandName.toLowerCase();
        }
        return StringUtil.splitAndTrim((String)commandName, (String)" ").stream().map(String::toLowerCase).collect(Collectors.joining("-"));
    }

    public static String percentEncodeString(String toEncode, String type) {
        if (toEncode == null) {
            return null;
        }
        PercentEscaper percentEscaper = new PercentEscaper("", false);
        return percentEscaper.escape(toEncode);
    }
}

