/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.util.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.liquibase.maven.plugins.AbstractLiquibaseMojo;

public class LiquibaseGenerateChangeLogMojo
extends AbstractLiquibaseMojo {
    private String diffTypes;
    private String dataDir;
    private String changeSetAuthor;
    protected String contexts;
    private String changeSetContext;
    protected String outputChangeLogFile;
    protected String diffExcludeObjects;
    protected String diffIncludeObjects;

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        ClassLoader cl = null;
        try {
            cl = this.getClassLoaderIncludingProjectClasspath();
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (MojoExecutionException e) {
            throw new LiquibaseException("Could not create the class loader, " + (Object)((Object)e), (Throwable)e);
        }
        Database database = liquibase.getDatabase();
        this.getLog().info((CharSequence)("Generating Change Log from database " + database.toString()));
        try {
            DiffOutputControl diffOutputControl = new DiffOutputControl(this.outputDefaultCatalog, this.outputDefaultSchema, true);
            if (this.diffExcludeObjects != null && this.diffIncludeObjects != null) {
                throw new UnexpectedLiquibaseException("Cannot specify both excludeObjects and includeObjects");
            }
            if (this.diffExcludeObjects != null) {
                diffOutputControl.setObjectChangeFilter((ObjectChangeFilter)new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, this.diffExcludeObjects));
            }
            if (this.diffIncludeObjects != null) {
                diffOutputControl.setObjectChangeFilter((ObjectChangeFilter)new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.INCLUDE, this.diffIncludeObjects));
            }
            CommandLineUtils.doGenerateChangeLog((String)this.outputChangeLogFile, (Database)database, (String)this.defaultCatalogName, (String)this.defaultSchemaName, (String)StringUtils.trimToNull((String)this.diffTypes), (String)StringUtils.trimToNull((String)this.changeSetAuthor), (String)StringUtils.trimToNull((String)this.changeSetContext), (String)StringUtils.trimToNull((String)this.dataDir), (DiffOutputControl)diffOutputControl);
            this.getLog().info((CharSequence)("Output written to Change Log file, " + this.outputChangeLogFile));
        }
        catch (IOException e) {
            throw new LiquibaseException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new LiquibaseException((Throwable)e);
        }
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "defaultSchemaName: " + this.defaultSchemaName));
        this.getLog().info((CharSequence)(indent + "diffTypes: " + this.diffTypes));
        this.getLog().info((CharSequence)(indent + "dataDir: " + this.dataDir));
    }
}

